@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Azure VM (Mercury) workload-specific backup policy.
 * @property backupManagementType This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
 * Expected value is 'AzureWorkload'.
 * @property makePolicyConsistent Fix the policy inconsistency
 * @property protectedItemsCount Number of items associated with this policy.
 * @property resourceGuardOperationRequests ResourceGuard Operation Requests
 * @property settings Common settings for the backup management
 * @property subProtectionPolicy List of sub-protection policies which includes schedule and retention
 * @property workLoadType Type of workload for the backup management
 */
public data class AzureVmWorkloadProtectionPolicyResponse(
    public val backupManagementType: String,
    public val makePolicyConsistent: Boolean? = null,
    public val protectedItemsCount: Int? = null,
    public val resourceGuardOperationRequests: List<String>? = null,
    public val settings: SettingsResponse? = null,
    public val subProtectionPolicy: List<SubProtectionPolicyResponse>? = null,
    public val workLoadType: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.AzureVmWorkloadProtectionPolicyResponse):
            AzureVmWorkloadProtectionPolicyResponse = AzureVmWorkloadProtectionPolicyResponse(
            backupManagementType = javaType.backupManagementType(),
            makePolicyConsistent = javaType.makePolicyConsistent().map({ args0 -> args0 }).orElse(null),
            protectedItemsCount = javaType.protectedItemsCount().map({ args0 -> args0 }).orElse(null),
            resourceGuardOperationRequests = javaType.resourceGuardOperationRequests().map({ args0 -> args0 }),
            settings = javaType.settings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.SettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            subProtectionPolicy = javaType.subProtectionPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.SubProtectionPolicyResponse.Companion.toKotlin(args0)
                })
            }),
            workLoadType = javaType.workLoadType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
