@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * This is used to represent the various nodes of the distributed container.
 * @property errorDetail Error Details if the Status is non-success.
 * @property nodeName Name of the node under a distributed container.
 * @property sourceResourceId ARM resource id of the node
 * @property status Status of this Node.
 * Failed | Succeeded
 */
public data class DistributedNodesInfoResponse(
    public val errorDetail: ErrorDetailResponse? = null,
    public val nodeName: String? = null,
    public val sourceResourceId: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.DistributedNodesInfoResponse):
            DistributedNodesInfoResponse = DistributedNodesInfoResponse(
            errorDetail = javaType.errorDetail().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.ErrorDetailResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            nodeName = javaType.nodeName().map({ args0 -> args0 }).orElse(null),
            sourceResourceId = javaType.sourceResourceId().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
