@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * HyperVSite fabric specific details.
 * @property hyperVHosts The list of Hyper-V hosts associated with the fabric.
 * @property instanceType Gets the class type. Overridden in derived classes.
 * Expected value is 'HyperVSite'.
 */
public data class HyperVSiteDetailsResponse(
    public val hyperVHosts: List<HyperVHostDetailsResponse>? = null,
    public val instanceType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.HyperVSiteDetailsResponse):
            HyperVSiteDetailsResponse = HyperVSiteDetailsResponse(
            hyperVHosts = javaType.hyperVHosts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.HyperVHostDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            instanceType = javaType.instanceType(),
        )
    }
}
