@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * InMageAzureV2 Managed disk details.
 * @property diskEncryptionSetId The DiskEncryptionSet ARM ID.
 * @property diskId The disk id.
 * @property replicaDiskType The replica disk type.
 * @property seedManagedDiskId Seed managed disk Id.
 * @property targetDiskName The target disk name.
 */
public data class InMageAzureV2ManagedDiskDetailsResponse(
    public val diskEncryptionSetId: String? = null,
    public val diskId: String? = null,
    public val replicaDiskType: String? = null,
    public val seedManagedDiskId: String? = null,
    public val targetDiskName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.InMageAzureV2ManagedDiskDetailsResponse):
            InMageAzureV2ManagedDiskDetailsResponse = InMageAzureV2ManagedDiskDetailsResponse(
            diskEncryptionSetId = javaType.diskEncryptionSetId().map({ args0 -> args0 }).orElse(null),
            diskId = javaType.diskId().map({ args0 -> args0 }).orElse(null),
            replicaDiskType = javaType.replicaDiskType().map({ args0 -> args0 }).orElse(null),
            seedManagedDiskId = javaType.seedManagedDiskId().map({ args0 -> args0 }).orElse(null),
            targetDiskName = javaType.targetDiskName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
