@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * InMageRcm failback specific policy details.
 * @property appConsistentFrequencyInMinutes The app consistent snapshot frequency in minutes.
 * @property crashConsistentFrequencyInMinutes The crash consistent snapshot frequency in minutes.
 * @property instanceType Gets the class type. Overridden in derived classes.
 * Expected value is 'InMageRcmFailback'.
 */
public data class InMageRcmFailbackPolicyDetailsResponse(
    public val appConsistentFrequencyInMinutes: Int? = null,
    public val crashConsistentFrequencyInMinutes: Int? = null,
    public val instanceType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.InMageRcmFailbackPolicyDetailsResponse):
            InMageRcmFailbackPolicyDetailsResponse = InMageRcmFailbackPolicyDetailsResponse(
            appConsistentFrequencyInMinutes = javaType.appConsistentFrequencyInMinutes().map({ args0 ->
                args0
            }).orElse(null),
            crashConsistentFrequencyInMinutes = javaType.crashConsistentFrequencyInMinutes().map({ args0 ->
                args0
            }).orElse(null),
            instanceType = javaType.instanceType(),
        )
    }
}
