@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Container with items backed up using MAB backup engine.
 * @property agentVersion Agent version of this container.
 * @property backupManagementType Type of backup management for the container.
 * @property canReRegister Can the container be registered one more time.
 * @property containerHealthState Health state of mab container.
 * @property containerId ContainerID represents the container.
 * @property containerType Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
 * Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
 * Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
 * Backup is VMAppContainer
 * Expected value is 'Windows'.
 * @property extendedInfo Additional information for this container
 * @property friendlyName Friendly name of the container.
 * @property healthStatus Status of health of the container.
 * @property mabContainerHealthDetails Health details on this mab container.
 * @property protectableObjectType Type of the protectable object associated with this container
 * @property protectedItemCount Number of items backed up in this container.
 * @property registrationStatus Status of registration of the container with the Recovery Services Vault.
 */
public data class MabContainerResponse(
    public val agentVersion: String? = null,
    public val backupManagementType: String? = null,
    public val canReRegister: Boolean? = null,
    public val containerHealthState: String? = null,
    public val containerId: Double? = null,
    public val containerType: String,
    public val extendedInfo: MabContainerExtendedInfoResponse? = null,
    public val friendlyName: String? = null,
    public val healthStatus: String? = null,
    public val mabContainerHealthDetails: List<MABContainerHealthDetailsResponse>? = null,
    public val protectableObjectType: String? = null,
    public val protectedItemCount: Double? = null,
    public val registrationStatus: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.MabContainerResponse):
            MabContainerResponse = MabContainerResponse(
            agentVersion = javaType.agentVersion().map({ args0 -> args0 }).orElse(null),
            backupManagementType = javaType.backupManagementType().map({ args0 -> args0 }).orElse(null),
            canReRegister = javaType.canReRegister().map({ args0 -> args0 }).orElse(null),
            containerHealthState = javaType.containerHealthState().map({ args0 -> args0 }).orElse(null),
            containerId = javaType.containerId().map({ args0 -> args0 }).orElse(null),
            containerType = javaType.containerType(),
            extendedInfo = javaType.extendedInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.MabContainerExtendedInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            friendlyName = javaType.friendlyName().map({ args0 -> args0 }).orElse(null),
            healthStatus = javaType.healthStatus().map({ args0 -> args0 }).orElse(null),
            mabContainerHealthDetails = javaType.mabContainerHealthDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.MABContainerHealthDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            protectableObjectType = javaType.protectableObjectType().map({ args0 -> args0 }).orElse(null),
            protectedItemCount = javaType.protectedItemCount().map({ args0 -> args0 }).orElse(null),
            registrationStatus = javaType.registrationStatus().map({ args0 -> args0 }).orElse(null),
        )
    }
}
