@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Network Mapping Properties.
 * @property fabricSpecificSettings The fabric specific settings.
 * @property primaryFabricFriendlyName The primary fabric friendly name.
 * @property primaryNetworkFriendlyName The primary network friendly name.
 * @property primaryNetworkId The primary network id for network mapping.
 * @property recoveryFabricArmId The recovery fabric ARM id.
 * @property recoveryFabricFriendlyName The recovery fabric friendly name.
 * @property recoveryNetworkFriendlyName The recovery network friendly name.
 * @property recoveryNetworkId The recovery network id for network mapping.
 * @property state The pairing state for network mapping.
 */
public data class NetworkMappingPropertiesResponse(
    public val fabricSpecificSettings: Any? = null,
    public val primaryFabricFriendlyName: String? = null,
    public val primaryNetworkFriendlyName: String? = null,
    public val primaryNetworkId: String? = null,
    public val recoveryFabricArmId: String? = null,
    public val recoveryFabricFriendlyName: String? = null,
    public val recoveryNetworkFriendlyName: String? = null,
    public val recoveryNetworkId: String? = null,
    public val state: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.NetworkMappingPropertiesResponse):
            NetworkMappingPropertiesResponse = NetworkMappingPropertiesResponse(
            fabricSpecificSettings = javaType.fabricSpecificSettings().map({ args0 -> args0 }).orElse(null),
            primaryFabricFriendlyName = javaType.primaryFabricFriendlyName().map({ args0 ->
                args0
            }).orElse(null),
            primaryNetworkFriendlyName = javaType.primaryNetworkFriendlyName().map({ args0 ->
                args0
            }).orElse(null),
            primaryNetworkId = javaType.primaryNetworkId().map({ args0 -> args0 }).orElse(null),
            recoveryFabricArmId = javaType.recoveryFabricArmId().map({ args0 -> args0 }).orElse(null),
            recoveryFabricFriendlyName = javaType.recoveryFabricFriendlyName().map({ args0 ->
                args0
            }).orElse(null),
            recoveryNetworkFriendlyName = javaType.recoveryNetworkFriendlyName().map({ args0 ->
                args0
            }).orElse(null),
            recoveryNetworkId = javaType.recoveryNetworkId().map({ args0 -> args0 }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
        )
    }
}
