@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Private Link Service Connection State
 * @property actionsRequired Gets or sets actions required
 * @property description Gets or sets description
 * @property status Gets or sets the status
 */
public data class PrivateLinkServiceConnectionStateResponse(
    public val actionsRequired: String? = null,
    public val description: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.PrivateLinkServiceConnectionStateResponse):
            PrivateLinkServiceConnectionStateResponse = PrivateLinkServiceConnectionStateResponse(
            actionsRequired = javaType.actionsRequired().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
