@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * RCM proxy details.
 * @property biosId The RCM proxy Bios Id.
 * @property clientAuthenticationType The client authentication type.
 * @property fabricObjectId The fabric object Id.
 * @property fqdn The RCM proxy Fqdn.
 * @property health The health of the RCM proxy.
 * @property healthErrors The health errors.
 * @property id The RCM proxy Id.
 * @property lastHeartbeatUtc The last heartbeat received from the RCM proxy.
 * @property name The RCM proxy name.
 * @property version The version.
 */
public data class RcmProxyDetailsResponse(
    public val biosId: String,
    public val clientAuthenticationType: String,
    public val fabricObjectId: String,
    public val fqdn: String,
    public val health: String,
    public val healthErrors: List<HealthErrorResponse>,
    public val id: String,
    public val lastHeartbeatUtc: String,
    public val name: String,
    public val version: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.RcmProxyDetailsResponse):
            RcmProxyDetailsResponse = RcmProxyDetailsResponse(
            biosId = javaType.biosId(),
            clientAuthenticationType = javaType.clientAuthenticationType(),
            fabricObjectId = javaType.fabricObjectId(),
            fqdn = javaType.fqdn(),
            health = javaType.health(),
            healthErrors = javaType.healthErrors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.HealthErrorResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            lastHeartbeatUtc = javaType.lastHeartbeatUtc(),
            name = javaType.name(),
            version = javaType.version(),
        )
    }
}
