@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Recovery plan manual action details.
 * @property description The manual action description.
 * @property instanceType Gets the type of action details (see RecoveryPlanActionDetailsTypes enum for possible values).
 * Expected value is 'ManualActionDetails'.
 */
public data class RecoveryPlanManualActionDetailsResponse(
    public val description: String? = null,
    public val instanceType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.RecoveryPlanManualActionDetailsResponse):
            RecoveryPlanManualActionDetailsResponse = RecoveryPlanManualActionDetailsResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            instanceType = javaType.instanceType(),
        )
    }
}
