@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * CS Accounts Details.
 * @property accountId The CS RunAs account Id.
 * @property accountName The CS RunAs account name.
 */
public data class RunAsAccountResponse(
    public val accountId: String? = null,
    public val accountName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.RunAsAccountResponse):
            RunAsAccountResponse = RunAsAccountResponse(
            accountId = javaType.accountId().map({ args0 -> args0 }).orElse(null),
            accountName = javaType.accountName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
