@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * VMwareCbt protected disk details.
 * @property capacityInBytes The disk capacity in bytes.
 * @property diskEncryptionSetId The DiskEncryptionSet ARM Id.
 * @property diskId The disk id.
 * @property diskName The disk name.
 * @property diskPath The disk path.
 * @property diskType The disk type.
 * @property isOSDisk A value indicating whether the disk is the OS disk.
 * @property logStorageAccountId The log storage account ARM Id.
 * @property logStorageAccountSasSecretName The key vault secret name of the log storage account.
 * @property seedBlobUri The uri of the seed blob.
 * @property seedManagedDiskId The ARM Id of the seed managed disk.
 * @property targetBlobUri The uri of the target blob.
 * @property targetDiskName The name for the target managed disk.
 * @property targetManagedDiskId The ARM Id of the target managed disk.
 */
public data class VMwareCbtProtectedDiskDetailsResponse(
    public val capacityInBytes: Double,
    public val diskEncryptionSetId: String,
    public val diskId: String,
    public val diskName: String,
    public val diskPath: String,
    public val diskType: String? = null,
    public val isOSDisk: String,
    public val logStorageAccountId: String,
    public val logStorageAccountSasSecretName: String,
    public val seedBlobUri: String,
    public val seedManagedDiskId: String,
    public val targetBlobUri: String,
    public val targetDiskName: String? = null,
    public val targetManagedDiskId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.VMwareCbtProtectedDiskDetailsResponse):
            VMwareCbtProtectedDiskDetailsResponse = VMwareCbtProtectedDiskDetailsResponse(
            capacityInBytes = javaType.capacityInBytes(),
            diskEncryptionSetId = javaType.diskEncryptionSetId(),
            diskId = javaType.diskId(),
            diskName = javaType.diskName(),
            diskPath = javaType.diskPath(),
            diskType = javaType.diskType().map({ args0 -> args0 }).orElse(null),
            isOSDisk = javaType.isOSDisk(),
            logStorageAccountId = javaType.logStorageAccountId(),
            logStorageAccountSasSecretName = javaType.logStorageAccountSasSecretName(),
            seedBlobUri = javaType.seedBlobUri(),
            seedManagedDiskId = javaType.seedManagedDiskId(),
            targetBlobUri = javaType.targetBlobUri(),
            targetDiskName = javaType.targetDiskName().map({ args0 -> args0 }).orElse(null),
            targetManagedDiskId = javaType.targetManagedDiskId(),
        )
    }
}
