@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * VMwareCbt security profile input.
 * @property isTargetVmConfidentialEncryptionEnabled A value indicating whether confidential compute encryption to be enabled.
 * @property isTargetVmIntegrityMonitoringEnabled A value indicating whether integrity monitoring to be enabled.
 * @property isTargetVmSecureBootEnabled A value indicating whether secure boot to be enabled.
 * @property isTargetVmTpmEnabled A value indicating whether trusted platform module to be enabled.
 * @property targetVmSecurityType The target VM security type.
 */
public data class VMwareCbtSecurityProfilePropertiesResponse(
    public val isTargetVmConfidentialEncryptionEnabled: String? = null,
    public val isTargetVmIntegrityMonitoringEnabled: String? = null,
    public val isTargetVmSecureBootEnabled: String? = null,
    public val isTargetVmTpmEnabled: String? = null,
    public val targetVmSecurityType: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.VMwareCbtSecurityProfilePropertiesResponse):
            VMwareCbtSecurityProfilePropertiesResponse = VMwareCbtSecurityProfilePropertiesResponse(
            isTargetVmConfidentialEncryptionEnabled = javaType.isTargetVmConfidentialEncryptionEnabled().map({ args0 ->
                args0
            }).orElse(null),
            isTargetVmIntegrityMonitoringEnabled = javaType.isTargetVmIntegrityMonitoringEnabled().map({ args0 ->
                args0
            }).orElse(null),
            isTargetVmSecureBootEnabled = javaType.isTargetVmSecureBootEnabled().map({ args0 ->
                args0
            }).orElse(null),
            isTargetVmTpmEnabled = javaType.isTargetVmTpmEnabled().map({ args0 -> args0 }).orElse(null),
            targetVmSecurityType = javaType.targetVmSecurityType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
