@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * VMwareV2 fabric specific details.
 * @property instanceType Gets the class type. Overridden in derived classes.
 * Expected value is 'VMwareV2'.
 * @property migrationSolutionId The Migration solution ARM Id.
 * @property physicalSiteId The ARM Id of the physical site.
 * @property processServers The list of process servers.
 * @property serviceContainerId The service container Id.
 * @property serviceEndpoint The service endpoint.
 * @property serviceResourceId The service resource Id.
 * @property vmwareSiteId The ARM Id of the VMware site.
 */
public data class VMwareV2FabricSpecificDetailsResponse(
    public val instanceType: String,
    public val migrationSolutionId: String,
    public val physicalSiteId: String,
    public val processServers: List<ProcessServerDetailsResponse>,
    public val serviceContainerId: String,
    public val serviceEndpoint: String,
    public val serviceResourceId: String,
    public val vmwareSiteId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.VMwareV2FabricSpecificDetailsResponse):
            VMwareV2FabricSpecificDetailsResponse = VMwareV2FabricSpecificDetailsResponse(
            instanceType = javaType.instanceType(),
            migrationSolutionId = javaType.migrationSolutionId(),
            physicalSiteId = javaType.physicalSiteId(),
            processServers = javaType.processServers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.ProcessServerDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            serviceContainerId = javaType.serviceContainerId(),
            serviceEndpoint = javaType.serviceEndpoint(),
            serviceResourceId = javaType.serviceResourceId(),
            vmwareSiteId = javaType.vmwareSiteId(),
        )
    }
}
