@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Customer Managed Key details of the resource.
 * @property infrastructureEncryption Enabling/Disabling the Double Encryption state
 * @property kekIdentity The details of the identity used for CMK
 * @property keyVaultProperties The properties of the Key Vault which hosts CMK
 */
public data class VaultPropertiesResponseEncryption(
    public val infrastructureEncryption: String? = null,
    public val kekIdentity: CmkKekIdentityResponse? = null,
    public val keyVaultProperties: CmkKeyVaultPropertiesResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.VaultPropertiesResponseEncryption):
            VaultPropertiesResponseEncryption = VaultPropertiesResponseEncryption(
            infrastructureEncryption = javaType.infrastructureEncryption().map({ args0 -> args0 }).orElse(null),
            kekIdentity = javaType.kekIdentity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.CmkKekIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            keyVaultProperties = javaType.keyVaultProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.CmkKeyVaultPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
