@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.redhatopenshift.kotlin

import com.pulumi.azurenative.redhatopenshift.SecretArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Secret represents a secret.
 * Azure REST API version: 2022-09-04.
 * Other available API versions: 2023-04-01, 2023-07-01-preview, 2023-09-04.
 * ## Example Usage
 * ### Creates or updates a Secret with the specified subscription, resource group and resource name.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var secret = new AzureNative.RedHatOpenShift.Secret("secret", new()
 *     {
 *         ChildResourceName = "childResourceName",
 *         ResourceGroupName = "resourceGroup",
 *         ResourceName = "resourceName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/redhatopenshift/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := redhatopenshift.NewSecret(ctx, "secret", &redhatopenshift.SecretArgs{
 * 			ChildResourceName: pulumi.String("childResourceName"),
 * 			ResourceGroupName: pulumi.String("resourceGroup"),
 * 			ResourceName:      pulumi.String("resourceName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.redhatopenshift.Secret;
 * import com.pulumi.azurenative.redhatopenshift.SecretArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var secret = new Secret("secret", SecretArgs.builder()
 *             .childResourceName("childResourceName")
 *             .resourceGroupName("resourceGroup")
 *             .resourceName("resourceName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:redhatopenshift:Secret mySecret /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RedHatOpenShift/openshiftclusters/{resourceName}/secret/{childResourceName}
 * ```
 * @property childResourceName The name of the Secret resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName The name of the OpenShift cluster resource.
 * @property secretResources The Secrets Resources.
 */
public data class SecretArgs(
    public val childResourceName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val secretResources: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.redhatopenshift.SecretArgs> {
    override fun toJava(): com.pulumi.azurenative.redhatopenshift.SecretArgs =
        com.pulumi.azurenative.redhatopenshift.SecretArgs.builder()
            .childResourceName(childResourceName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .secretResources(secretResources?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecretArgs].
 */
@PulumiTagMarker
public class SecretArgsBuilder internal constructor() {
    private var childResourceName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var secretResources: Output<String>? = null

    /**
     * @param value The name of the Secret resource.
     */
    @JvmName("sqcmenpjgkvifbhh")
    public suspend fun childResourceName(`value`: Output<String>) {
        this.childResourceName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("llrlmfcpmvhqdsyu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the OpenShift cluster resource.
     */
    @JvmName("yneexppnnhhyestc")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value The Secrets Resources.
     */
    @JvmName("ebaitbxajebwrfox")
    public suspend fun secretResources(`value`: Output<String>) {
        this.secretResources = value
    }

    /**
     * @param value The name of the Secret resource.
     */
    @JvmName("jllutbjaovhbgrfj")
    public suspend fun childResourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.childResourceName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jywaerdfbxlamflg")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the OpenShift cluster resource.
     */
    @JvmName("oinlymfvqmqivebk")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value The Secrets Resources.
     */
    @JvmName("gjjalkqycvfntnoj")
    public suspend fun secretResources(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretResources = mapped
    }

    internal fun build(): SecretArgs = SecretArgs(
        childResourceName = childResourceName,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        secretResources = secretResources,
    )
}
