@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.redhatopenshift.kotlin.inputs

import com.pulumi.azurenative.redhatopenshift.inputs.APIServerProfileArgs.builder
import com.pulumi.azurenative.redhatopenshift.kotlin.enums.Visibility
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * APIServerProfile represents an API server profile.
 * @property ip The IP of the cluster API server.
 * @property url The URL to access the cluster API server.
 * @property visibility API server visibility.
 */
public data class APIServerProfileArgs(
    public val ip: Output<String>? = null,
    public val url: Output<String>? = null,
    public val visibility: Output<Either<String, Visibility>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.redhatopenshift.inputs.APIServerProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.redhatopenshift.inputs.APIServerProfileArgs =
        com.pulumi.azurenative.redhatopenshift.inputs.APIServerProfileArgs.builder()
            .ip(ip?.applyValue({ args0 -> args0 }))
            .url(url?.applyValue({ args0 -> args0 }))
            .visibility(
                visibility?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [APIServerProfileArgs].
 */
@PulumiTagMarker
public class APIServerProfileArgsBuilder internal constructor() {
    private var ip: Output<String>? = null

    private var url: Output<String>? = null

    private var visibility: Output<Either<String, Visibility>>? = null

    /**
     * @param value The IP of the cluster API server.
     */
    @JvmName("kgmwlvisyfmtkjwj")
    public suspend fun ip(`value`: Output<String>) {
        this.ip = value
    }

    /**
     * @param value The URL to access the cluster API server.
     */
    @JvmName("olhqikmjkngbrjhr")
    public suspend fun url(`value`: Output<String>) {
        this.url = value
    }

    /**
     * @param value API server visibility.
     */
    @JvmName("uvbnfkdifrjgimqt")
    public suspend fun visibility(`value`: Output<Either<String, Visibility>>) {
        this.visibility = value
    }

    /**
     * @param value The IP of the cluster API server.
     */
    @JvmName("evtlhpafvhfpbpjp")
    public suspend fun ip(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ip = mapped
    }

    /**
     * @param value The URL to access the cluster API server.
     */
    @JvmName("qgcnjlbolrucphmx")
    public suspend fun url(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.url = mapped
    }

    /**
     * @param value API server visibility.
     */
    @JvmName("vduxyfjsvivsldjo")
    public suspend fun visibility(`value`: Either<String, Visibility>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.visibility = mapped
    }

    /**
     * @param value API server visibility.
     */
    @JvmName("uwygxbhfewniqsmw")
    public fun visibility(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Visibility>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.visibility = mapped
    }

    /**
     * @param value API server visibility.
     */
    @JvmName("jxhdaolqxsvyqyci")
    public fun visibility(`value`: Visibility) {
        val toBeMapped = Either.ofRight<String, Visibility>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.visibility = mapped
    }

    internal fun build(): APIServerProfileArgs = APIServerProfileArgs(
        ip = ip,
        url = url,
        visibility = visibility,
    )
}
