@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.redhatopenshift.kotlin.inputs

import com.pulumi.azurenative.redhatopenshift.inputs.ConsoleProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * ConsoleProfile represents a console profile.
 * @property url The URL to access the cluster console.
 */
public data class ConsoleProfileArgs(
    public val url: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.redhatopenshift.inputs.ConsoleProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.redhatopenshift.inputs.ConsoleProfileArgs =
        com.pulumi.azurenative.redhatopenshift.inputs.ConsoleProfileArgs.builder()
            .url(url?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConsoleProfileArgs].
 */
@PulumiTagMarker
public class ConsoleProfileArgsBuilder internal constructor() {
    private var url: Output<String>? = null

    /**
     * @param value The URL to access the cluster console.
     */
    @JvmName("wkbamxxludkmgsht")
    public suspend fun url(`value`: Output<String>) {
        this.url = value
    }

    /**
     * @param value The URL to access the cluster console.
     */
    @JvmName("grblxfahcrroaxae")
    public suspend fun url(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.url = mapped
    }

    internal fun build(): ConsoleProfileArgs = ConsoleProfileArgs(
        url = url,
    )
}
