@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.redhatopenshift.kotlin.inputs

import com.pulumi.azurenative.redhatopenshift.inputs.GetSyncIdentityProviderPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property childResourceName The name of the SyncIdentityProvider resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName The name of the OpenShift cluster resource.
 */
public data class GetSyncIdentityProviderPlainArgs(
    public val childResourceName: String,
    public val resourceGroupName: String,
    public val resourceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.redhatopenshift.inputs.GetSyncIdentityProviderPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.redhatopenshift.inputs.GetSyncIdentityProviderPlainArgs =
        com.pulumi.azurenative.redhatopenshift.inputs.GetSyncIdentityProviderPlainArgs.builder()
            .childResourceName(childResourceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSyncIdentityProviderPlainArgs].
 */
@PulumiTagMarker
public class GetSyncIdentityProviderPlainArgsBuilder internal constructor() {
    private var childResourceName: String? = null

    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    /**
     * @param value The name of the SyncIdentityProvider resource.
     */
    @JvmName("wxufbguhwrlwesll")
    public suspend fun childResourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.childResourceName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("eboqdjprjkblvrha")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the OpenShift cluster resource.
     */
    @JvmName("wcjiikukfashgquk")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    internal fun build(): GetSyncIdentityProviderPlainArgs = GetSyncIdentityProviderPlainArgs(
        childResourceName = childResourceName ?: throw PulumiNullFieldException("childResourceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
    )
}
