@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.redhatopenshift.kotlin.inputs

import com.pulumi.azurenative.redhatopenshift.inputs.ListOpenShiftClusterAdminCredentialsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName The name of the OpenShift cluster resource.
 */
public data class ListOpenShiftClusterAdminCredentialsPlainArgs(
    public val resourceGroupName: String,
    public val resourceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.redhatopenshift.inputs.ListOpenShiftClusterAdminCredentialsPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.redhatopenshift.inputs.ListOpenShiftClusterAdminCredentialsPlainArgs =
        com.pulumi.azurenative.redhatopenshift.inputs.ListOpenShiftClusterAdminCredentialsPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListOpenShiftClusterAdminCredentialsPlainArgs].
 */
@PulumiTagMarker
public class ListOpenShiftClusterAdminCredentialsPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("imqdlaaqecarlycr")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the OpenShift cluster resource.
     */
    @JvmName("voqswumqkqyjprew")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    internal fun build(): ListOpenShiftClusterAdminCredentialsPlainArgs =
        ListOpenShiftClusterAdminCredentialsPlainArgs(
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
        )
}
