@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.redhatopenshift.kotlin.inputs

import com.pulumi.azurenative.redhatopenshift.inputs.ServicePrincipalProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * ServicePrincipalProfile represents a service principal profile.
 * @property clientId The client ID used for the cluster.
 * @property clientSecret The client secret used for the cluster.
 */
public data class ServicePrincipalProfileArgs(
    public val clientId: Output<String>? = null,
    public val clientSecret: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.redhatopenshift.inputs.ServicePrincipalProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.redhatopenshift.inputs.ServicePrincipalProfileArgs =
        com.pulumi.azurenative.redhatopenshift.inputs.ServicePrincipalProfileArgs.builder()
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .clientSecret(clientSecret?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServicePrincipalProfileArgs].
 */
@PulumiTagMarker
public class ServicePrincipalProfileArgsBuilder internal constructor() {
    private var clientId: Output<String>? = null

    private var clientSecret: Output<String>? = null

    /**
     * @param value The client ID used for the cluster.
     */
    @JvmName("abqsedgpogolqjeu")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value The client secret used for the cluster.
     */
    @JvmName("cfnqcuytdmnwkkwq")
    public suspend fun clientSecret(`value`: Output<String>) {
        this.clientSecret = value
    }

    /**
     * @param value The client ID used for the cluster.
     */
    @JvmName("klhvebsognknspme")
    public suspend fun clientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value The client secret used for the cluster.
     */
    @JvmName("sauxgklhkchcwjvp")
    public suspend fun clientSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    internal fun build(): ServicePrincipalProfileArgs = ServicePrincipalProfileArgs(
        clientId = clientId,
        clientSecret = clientSecret,
    )
}
