@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.redhatopenshift.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * APIServerProfile represents an API server profile.
 * @property ip The IP of the cluster API server.
 * @property url The URL to access the cluster API server.
 * @property visibility API server visibility.
 */
public data class APIServerProfileResponse(
    public val ip: String? = null,
    public val url: String? = null,
    public val visibility: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.redhatopenshift.outputs.APIServerProfileResponse):
            APIServerProfileResponse = APIServerProfileResponse(
            ip = javaType.ip().map({ args0 -> args0 }).orElse(null),
            url = javaType.url().map({ args0 -> args0 }).orElse(null),
            visibility = javaType.visibility().map({ args0 -> args0 }).orElse(null),
        )
    }
}
