@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.redhatopenshift.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * WorkerProfile represents a worker profile.
 * @property count The number of worker VMs.
 * @property diskEncryptionSetId The resource ID of an associated DiskEncryptionSet, if applicable.
 * @property diskSizeGB The disk size of the worker VMs.
 * @property encryptionAtHost Whether master virtual machines are encrypted at host.
 * @property name The worker profile name.
 * @property subnetId The Azure resource ID of the worker subnet.
 * @property vmSize The size of the worker VMs.
 */
public data class WorkerProfileResponse(
    public val count: Int? = null,
    public val diskEncryptionSetId: String? = null,
    public val diskSizeGB: Int? = null,
    public val encryptionAtHost: String? = null,
    public val name: String? = null,
    public val subnetId: String? = null,
    public val vmSize: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.redhatopenshift.outputs.WorkerProfileResponse):
            WorkerProfileResponse = WorkerProfileResponse(
            count = javaType.count().map({ args0 -> args0 }).orElse(null),
            diskEncryptionSetId = javaType.diskEncryptionSetId().map({ args0 -> args0 }).orElse(null),
            diskSizeGB = javaType.diskSizeGB().map({ args0 -> args0 }).orElse(null),
            encryptionAtHost = javaType.encryptionAtHost().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            subnetId = javaType.subnetId().map({ args0 -> args0 }).orElse(null),
            vmSize = javaType.vmSize().map({ args0 -> args0 }).orElse(null),
        )
    }
}
