@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.relay.kotlin.inputs

import com.pulumi.azurenative.relay.inputs.GetWCFRelayPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property namespaceName The namespace name
 * @property relayName The relay name.
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 */
public data class GetWCFRelayPlainArgs(
    public val namespaceName: String,
    public val relayName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.relay.inputs.GetWCFRelayPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.relay.inputs.GetWCFRelayPlainArgs =
        com.pulumi.azurenative.relay.inputs.GetWCFRelayPlainArgs.builder()
            .namespaceName(namespaceName.let({ args0 -> args0 }))
            .relayName(relayName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWCFRelayPlainArgs].
 */
@PulumiTagMarker
public class GetWCFRelayPlainArgsBuilder internal constructor() {
    private var namespaceName: String? = null

    private var relayName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The namespace name
     */
    @JvmName("andyueshtkgmhgqj")
    public suspend fun namespaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.namespaceName = mapped
    }

    /**
     * @param value The relay name.
     */
    @JvmName("yfmfwslnetglylss")
    public suspend fun relayName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.relayName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("frpcbotxlbpnjjuu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetWCFRelayPlainArgs = GetWCFRelayPlainArgs(
        namespaceName = namespaceName ?: throw PulumiNullFieldException("namespaceName"),
        relayName = relayName ?: throw PulumiNullFieldException("relayName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
