@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resourceconnector.kotlin

import com.pulumi.azurenative.resourceconnector.ResourceconnectorFunctions.getAppliancePlain
import com.pulumi.azurenative.resourceconnector.ResourceconnectorFunctions.listApplianceClusterCustomerUserCredentialPlain
import com.pulumi.azurenative.resourceconnector.ResourceconnectorFunctions.listApplianceClusterUserCredentialPlain
import com.pulumi.azurenative.resourceconnector.ResourceconnectorFunctions.listApplianceKeysPlain
import com.pulumi.azurenative.resourceconnector.kotlin.inputs.GetAppliancePlainArgs
import com.pulumi.azurenative.resourceconnector.kotlin.inputs.GetAppliancePlainArgsBuilder
import com.pulumi.azurenative.resourceconnector.kotlin.inputs.ListApplianceClusterCustomerUserCredentialPlainArgs
import com.pulumi.azurenative.resourceconnector.kotlin.inputs.ListApplianceClusterCustomerUserCredentialPlainArgsBuilder
import com.pulumi.azurenative.resourceconnector.kotlin.inputs.ListApplianceClusterUserCredentialPlainArgs
import com.pulumi.azurenative.resourceconnector.kotlin.inputs.ListApplianceClusterUserCredentialPlainArgsBuilder
import com.pulumi.azurenative.resourceconnector.kotlin.inputs.ListApplianceKeysPlainArgs
import com.pulumi.azurenative.resourceconnector.kotlin.inputs.ListApplianceKeysPlainArgsBuilder
import com.pulumi.azurenative.resourceconnector.kotlin.outputs.GetApplianceResult
import com.pulumi.azurenative.resourceconnector.kotlin.outputs.ListApplianceClusterCustomerUserCredentialResult
import com.pulumi.azurenative.resourceconnector.kotlin.outputs.ListApplianceClusterUserCredentialResult
import com.pulumi.azurenative.resourceconnector.kotlin.outputs.ListApplianceKeysResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.resourceconnector.kotlin.outputs.GetApplianceResult.Companion.toKotlin as getApplianceResultToKotlin
import com.pulumi.azurenative.resourceconnector.kotlin.outputs.ListApplianceClusterCustomerUserCredentialResult.Companion.toKotlin as listApplianceClusterCustomerUserCredentialResultToKotlin
import com.pulumi.azurenative.resourceconnector.kotlin.outputs.ListApplianceClusterUserCredentialResult.Companion.toKotlin as listApplianceClusterUserCredentialResultToKotlin
import com.pulumi.azurenative.resourceconnector.kotlin.outputs.ListApplianceKeysResult.Companion.toKotlin as listApplianceKeysResultToKotlin

public object ResourceconnectorFunctions {
    /**
     * Gets the details of an Appliance with a specified resource group and name.
     * Azure REST API version: 2022-10-27.
     * Other available API versions: 2021-10-31-preview.
     * @param argument null
     * @return Appliances definition.
     */
    public suspend fun getAppliance(argument: GetAppliancePlainArgs): GetApplianceResult =
        getApplianceResultToKotlin(getAppliancePlain(argument.toJava()).await())

    /**
     * @see [getAppliance].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName Appliances name.
     * @return Appliances definition.
     */
    public suspend fun getAppliance(resourceGroupName: String, resourceName: String):
        GetApplianceResult {
        val argument = GetAppliancePlainArgs(
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getApplianceResultToKotlin(getAppliancePlain(argument.toJava()).await())
    }

    /**
     * @see [getAppliance].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;resourceconnector&#46;kotlin&#46;inputs&#46;GetAppliancePlainArgs].
     * @return Appliances definition.
     */
    public suspend fun getAppliance(argument: suspend GetAppliancePlainArgsBuilder.() -> Unit):
        GetApplianceResult {
        val builder = GetAppliancePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getApplianceResultToKotlin(getAppliancePlain(builtArgument.toJava()).await())
    }

    /**
     * Returns the cluster customer user credentials for the dedicated appliance.
     * Azure REST API version: 2022-04-15-preview.
     * @param argument null
     * @return The List Cluster Customer User Credential Results appliance.
     */
    public suspend
    fun listApplianceClusterCustomerUserCredential(argument: ListApplianceClusterCustomerUserCredentialPlainArgs):
        ListApplianceClusterCustomerUserCredentialResult =
        listApplianceClusterCustomerUserCredentialResultToKotlin(listApplianceClusterCustomerUserCredentialPlain(argument.toJava()).await())

    /**
     * @see [listApplianceClusterCustomerUserCredential].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName Appliances name.
     * @return The List Cluster Customer User Credential Results appliance.
     */
    public suspend fun listApplianceClusterCustomerUserCredential(
        resourceGroupName: String,
        resourceName: String,
    ): ListApplianceClusterCustomerUserCredentialResult {
        val argument = ListApplianceClusterCustomerUserCredentialPlainArgs(
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return listApplianceClusterCustomerUserCredentialResultToKotlin(listApplianceClusterCustomerUserCredentialPlain(argument.toJava()).await())
    }

    /**
     * @see [listApplianceClusterCustomerUserCredential].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;resourceconnector&#46;kotlin&#46;inputs&#46;ListApplianceClusterCustomerUserCredentialPlainArgs].
     * @return The List Cluster Customer User Credential Results appliance.
     */
    public suspend
    fun listApplianceClusterCustomerUserCredential(argument: suspend ListApplianceClusterCustomerUserCredentialPlainArgsBuilder.() -> Unit):
        ListApplianceClusterCustomerUserCredentialResult {
        val builder = ListApplianceClusterCustomerUserCredentialPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listApplianceClusterCustomerUserCredentialResultToKotlin(listApplianceClusterCustomerUserCredentialPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns the cluster user credentials for the dedicated appliance.
     * Azure REST API version: 2022-10-27.
     * Other available API versions: 2021-10-31-preview.
     * @param argument null
     * @return The List Cluster User Credential appliance.
     */
    public suspend
    fun listApplianceClusterUserCredential(argument: ListApplianceClusterUserCredentialPlainArgs):
        ListApplianceClusterUserCredentialResult =
        listApplianceClusterUserCredentialResultToKotlin(listApplianceClusterUserCredentialPlain(argument.toJava()).await())

    /**
     * @see [listApplianceClusterUserCredential].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName Appliances name.
     * @return The List Cluster User Credential appliance.
     */
    public suspend fun listApplianceClusterUserCredential(
        resourceGroupName: String,
        resourceName: String,
    ): ListApplianceClusterUserCredentialResult {
        val argument = ListApplianceClusterUserCredentialPlainArgs(
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return listApplianceClusterUserCredentialResultToKotlin(listApplianceClusterUserCredentialPlain(argument.toJava()).await())
    }

    /**
     * @see [listApplianceClusterUserCredential].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;resourceconnector&#46;kotlin&#46;inputs&#46;ListApplianceClusterUserCredentialPlainArgs].
     * @return The List Cluster User Credential appliance.
     */
    public suspend
    fun listApplianceClusterUserCredential(argument: suspend ListApplianceClusterUserCredentialPlainArgsBuilder.() -> Unit):
        ListApplianceClusterUserCredentialResult {
        val builder = ListApplianceClusterUserCredentialPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listApplianceClusterUserCredentialResultToKotlin(listApplianceClusterUserCredentialPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns the cluster customer credentials for the dedicated appliance.
     * Azure REST API version: 2022-10-27.
     * @param argument null
     * @return The List Cluster Keys Results appliance.
     */
    public suspend fun listApplianceKeys(argument: ListApplianceKeysPlainArgs):
        ListApplianceKeysResult =
        listApplianceKeysResultToKotlin(listApplianceKeysPlain(argument.toJava()).await())

    /**
     * @see [listApplianceKeys].
     * @param artifactType This sets the type of artifact being returned, when empty no artifact endpoint is returned.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName Appliances name.
     * @return The List Cluster Keys Results appliance.
     */
    public suspend fun listApplianceKeys(
        artifactType: String? = null,
        resourceGroupName: String,
        resourceName: String,
    ): ListApplianceKeysResult {
        val argument = ListApplianceKeysPlainArgs(
            artifactType = artifactType,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return listApplianceKeysResultToKotlin(listApplianceKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listApplianceKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;resourceconnector&#46;kotlin&#46;inputs&#46;ListApplianceKeysPlainArgs].
     * @return The List Cluster Keys Results appliance.
     */
    public suspend
    fun listApplianceKeys(argument: suspend ListApplianceKeysPlainArgsBuilder.() -> Unit):
        ListApplianceKeysResult {
        val builder = ListApplianceKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listApplianceKeysResultToKotlin(listApplianceKeysPlain(builtArgument.toJava()).await())
    }
}
