@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resourceconnector.kotlin.inputs

import com.pulumi.azurenative.resourceconnector.inputs.AppliancePropertiesInfrastructureConfigArgs.builder
import com.pulumi.azurenative.resourceconnector.kotlin.enums.Provider
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Contains infrastructure information about the Appliance
 * @property provider Information about the connected appliance.
 */
public data class AppliancePropertiesInfrastructureConfigArgs(
    public val provider: Output<Either<String, Provider>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.resourceconnector.inputs.AppliancePropertiesInfrastructureConfigArgs> {
    override fun toJava():
        com.pulumi.azurenative.resourceconnector.inputs.AppliancePropertiesInfrastructureConfigArgs =
        com.pulumi.azurenative.resourceconnector.inputs.AppliancePropertiesInfrastructureConfigArgs.builder()
            .provider(
                provider?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [AppliancePropertiesInfrastructureConfigArgs].
 */
@PulumiTagMarker
public class AppliancePropertiesInfrastructureConfigArgsBuilder internal constructor() {
    private var provider: Output<Either<String, Provider>>? = null

    /**
     * @param value Information about the connected appliance.
     */
    @JvmName("hfvrfsbqogpnndyt")
    public suspend fun provider(`value`: Output<Either<String, Provider>>) {
        this.provider = value
    }

    /**
     * @param value Information about the connected appliance.
     */
    @JvmName("vgmmjnxfpthicnjv")
    public suspend fun provider(`value`: Either<String, Provider>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provider = mapped
    }

    /**
     * @param value Information about the connected appliance.
     */
    @JvmName("bqvyighvvjaltyjn")
    public fun provider(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Provider>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provider = mapped
    }

    /**
     * @param value Information about the connected appliance.
     */
    @JvmName("gwvymwihichrbvha")
    public fun provider(`value`: Provider) {
        val toBeMapped = Either.ofRight<String, Provider>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provider = mapped
    }

    internal fun build(): AppliancePropertiesInfrastructureConfigArgs =
        AppliancePropertiesInfrastructureConfigArgs(
            provider = provider,
        )
}
