@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resourcegraph.kotlin.inputs

import com.pulumi.azurenative.resourcegraph.inputs.GetGraphQueryPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group.
 * @property resourceName The name of the Graph Query resource.
 */
public data class GetGraphQueryPlainArgs(
    public val resourceGroupName: String,
    public val resourceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.resourcegraph.inputs.GetGraphQueryPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.resourcegraph.inputs.GetGraphQueryPlainArgs =
        com.pulumi.azurenative.resourcegraph.inputs.GetGraphQueryPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGraphQueryPlainArgs].
 */
@PulumiTagMarker
public class GetGraphQueryPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    /**
     * @param value The name of the resource group.
     */
    @JvmName("yedaxdjpvoamkimu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Graph Query resource.
     */
    @JvmName("hqeajsdxaqvsvwoi")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    internal fun build(): GetGraphQueryPlainArgs = GetGraphQueryPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
    )
}
