@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resourcehealth.kotlin

import com.pulumi.azurenative.resourcehealth.ResourcehealthFunctions.listSecurityAdvisoryImpactedResourceBySubscriptionIdAndEventIdPlain
import com.pulumi.azurenative.resourcehealth.ResourcehealthFunctions.listSecurityAdvisoryImpactedResourceByTenantIdAndEventIdPlain
import com.pulumi.azurenative.resourcehealth.kotlin.inputs.ListSecurityAdvisoryImpactedResourceBySubscriptionIdAndEventIdPlainArgs
import com.pulumi.azurenative.resourcehealth.kotlin.inputs.ListSecurityAdvisoryImpactedResourceBySubscriptionIdAndEventIdPlainArgsBuilder
import com.pulumi.azurenative.resourcehealth.kotlin.inputs.ListSecurityAdvisoryImpactedResourceByTenantIdAndEventIdPlainArgs
import com.pulumi.azurenative.resourcehealth.kotlin.inputs.ListSecurityAdvisoryImpactedResourceByTenantIdAndEventIdPlainArgsBuilder
import com.pulumi.azurenative.resourcehealth.kotlin.outputs.ListSecurityAdvisoryImpactedResourceBySubscriptionIdAndEventIdResult
import com.pulumi.azurenative.resourcehealth.kotlin.outputs.ListSecurityAdvisoryImpactedResourceByTenantIdAndEventIdResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.resourcehealth.kotlin.outputs.ListSecurityAdvisoryImpactedResourceBySubscriptionIdAndEventIdResult.Companion.toKotlin as listSecurityAdvisoryImpactedResourceBySubscriptionIdAndEventIdResultToKotlin
import com.pulumi.azurenative.resourcehealth.kotlin.outputs.ListSecurityAdvisoryImpactedResourceByTenantIdAndEventIdResult.Companion.toKotlin as listSecurityAdvisoryImpactedResourceByTenantIdAndEventIdResultToKotlin

public object ResourcehealthFunctions {
    /**
     * Lists impacted resources in the subscription by an event (Security Advisory).
     * Azure REST API version: 2022-10-01.
     * Other available API versions: 2022-10-01-preview, 2023-07-01-preview, 2023-10-01-preview.
     * @param argument null
     * @return The List of eventImpactedResources operation response.
     */
    public suspend
    fun listSecurityAdvisoryImpactedResourceBySubscriptionIdAndEventId(argument: ListSecurityAdvisoryImpactedResourceBySubscriptionIdAndEventIdPlainArgs):
        ListSecurityAdvisoryImpactedResourceBySubscriptionIdAndEventIdResult =
        listSecurityAdvisoryImpactedResourceBySubscriptionIdAndEventIdResultToKotlin(listSecurityAdvisoryImpactedResourceBySubscriptionIdAndEventIdPlain(argument.toJava()).await())

    /**
     * @see [listSecurityAdvisoryImpactedResourceBySubscriptionIdAndEventId].
     * @param eventTrackingId Event Id which uniquely identifies ServiceHealth event.
     * @param filter The filter to apply on the operation. For more information please see https://docs.microsoft.com/en-us/rest/api/apimanagement/apis?redirectedfrom=MSDN
     * @return The List of eventImpactedResources operation response.
     */
    public suspend
    fun listSecurityAdvisoryImpactedResourceBySubscriptionIdAndEventId(
        eventTrackingId: String,
        filter: String? = null,
    ):
        ListSecurityAdvisoryImpactedResourceBySubscriptionIdAndEventIdResult {
        val argument = ListSecurityAdvisoryImpactedResourceBySubscriptionIdAndEventIdPlainArgs(
            eventTrackingId = eventTrackingId,
            filter = filter,
        )
        return listSecurityAdvisoryImpactedResourceBySubscriptionIdAndEventIdResultToKotlin(listSecurityAdvisoryImpactedResourceBySubscriptionIdAndEventIdPlain(argument.toJava()).await())
    }

    /**
     * @see [listSecurityAdvisoryImpactedResourceBySubscriptionIdAndEventId].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;resourcehealth&#46;kotlin&#46;inputs&#46;ListSecurityAdvisoryImpactedResourceBySubscriptionIdAndEventIdPlainArgs].
     * @return The List of eventImpactedResources operation response.
     */
    public suspend
    fun listSecurityAdvisoryImpactedResourceBySubscriptionIdAndEventId(argument: suspend ListSecurityAdvisoryImpactedResourceBySubscriptionIdAndEventIdPlainArgsBuilder.() -> Unit):
        ListSecurityAdvisoryImpactedResourceBySubscriptionIdAndEventIdResult {
        val builder = ListSecurityAdvisoryImpactedResourceBySubscriptionIdAndEventIdPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listSecurityAdvisoryImpactedResourceBySubscriptionIdAndEventIdResultToKotlin(listSecurityAdvisoryImpactedResourceBySubscriptionIdAndEventIdPlain(builtArgument.toJava()).await())
    }

    /**
     * Lists impacted resources in the tenant by an event (Security Advisory).
     * Azure REST API version: 2022-10-01.
     * Other available API versions: 2022-10-01-preview, 2023-07-01-preview, 2023-10-01-preview.
     * @param argument null
     * @return The List of eventImpactedResources operation response.
     */
    public suspend
    fun listSecurityAdvisoryImpactedResourceByTenantIdAndEventId(argument: ListSecurityAdvisoryImpactedResourceByTenantIdAndEventIdPlainArgs):
        ListSecurityAdvisoryImpactedResourceByTenantIdAndEventIdResult =
        listSecurityAdvisoryImpactedResourceByTenantIdAndEventIdResultToKotlin(listSecurityAdvisoryImpactedResourceByTenantIdAndEventIdPlain(argument.toJava()).await())

    /**
     * @see [listSecurityAdvisoryImpactedResourceByTenantIdAndEventId].
     * @param eventTrackingId Event Id which uniquely identifies ServiceHealth event.
     * @param filter The filter to apply on the operation. For more information please see https://docs.microsoft.com/en-us/rest/api/apimanagement/apis?redirectedfrom=MSDN
     * @return The List of eventImpactedResources operation response.
     */
    public suspend
    fun listSecurityAdvisoryImpactedResourceByTenantIdAndEventId(
        eventTrackingId: String,
        filter: String? = null,
    ): ListSecurityAdvisoryImpactedResourceByTenantIdAndEventIdResult {
        val argument = ListSecurityAdvisoryImpactedResourceByTenantIdAndEventIdPlainArgs(
            eventTrackingId = eventTrackingId,
            filter = filter,
        )
        return listSecurityAdvisoryImpactedResourceByTenantIdAndEventIdResultToKotlin(listSecurityAdvisoryImpactedResourceByTenantIdAndEventIdPlain(argument.toJava()).await())
    }

    /**
     * @see [listSecurityAdvisoryImpactedResourceByTenantIdAndEventId].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;resourcehealth&#46;kotlin&#46;inputs&#46;ListSecurityAdvisoryImpactedResourceByTenantIdAndEventIdPlainArgs].
     * @return The List of eventImpactedResources operation response.
     */
    public suspend
    fun listSecurityAdvisoryImpactedResourceByTenantIdAndEventId(argument: suspend ListSecurityAdvisoryImpactedResourceByTenantIdAndEventIdPlainArgsBuilder.() -> Unit):
        ListSecurityAdvisoryImpactedResourceByTenantIdAndEventIdResult {
        val builder = ListSecurityAdvisoryImpactedResourceByTenantIdAndEventIdPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listSecurityAdvisoryImpactedResourceByTenantIdAndEventIdResultToKotlin(listSecurityAdvisoryImpactedResourceByTenantIdAndEventIdPlain(builtArgument.toJava()).await())
    }
}
