@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin

import com.pulumi.azurenative.resources.AzurePowerShellScriptArgs.builder
import com.pulumi.azurenative.resources.kotlin.enums.CleanupOptions
import com.pulumi.azurenative.resources.kotlin.inputs.ContainerConfigurationArgs
import com.pulumi.azurenative.resources.kotlin.inputs.ContainerConfigurationArgsBuilder
import com.pulumi.azurenative.resources.kotlin.inputs.EnvironmentVariableArgs
import com.pulumi.azurenative.resources.kotlin.inputs.EnvironmentVariableArgsBuilder
import com.pulumi.azurenative.resources.kotlin.inputs.ManagedServiceIdentityArgs
import com.pulumi.azurenative.resources.kotlin.inputs.ManagedServiceIdentityArgsBuilder
import com.pulumi.azurenative.resources.kotlin.inputs.StorageAccountConfigurationArgs
import com.pulumi.azurenative.resources.kotlin.inputs.StorageAccountConfigurationArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Object model for the Azure PowerShell script.
 * Azure REST API version: 2020-10-01. Prior API version in Azure Native 1.x: 2020-10-01.
 * ## Example Usage
 * ### DeploymentScriptsCreateNoUserManagedIdentity
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var azurePowerShellScript = new AzureNative.Resources.AzurePowerShellScript("azurePowerShellScript", new()
 *     {
 *         Arguments = "-Location 'westus' -Name \"*rg2\"",
 *         AzPowerShellVersion = "1.7.0",
 *         CleanupPreference = "Always",
 *         Kind = "AzurePowerShell",
 *         Location = "westus",
 *         ResourceGroupName = "script-rg",
 *         RetentionInterval = "PT7D",
 *         ScriptContent = "Param([string]$Location,[string]$Name) $deploymentScriptOutputs['test'] = 'value' Get-AzResourceGroup -Location $Location -Name $Name",
 *         ScriptName = "MyDeploymentScript",
 *         SupportingScriptUris = new[]
 *         {
 *             "https://uri1.to.supporting.script",
 *             "https://uri2.to.supporting.script",
 *         },
 *         Timeout = "PT1H",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/resources/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := resources.NewAzurePowerShellScript(ctx, "azurePowerShellScript", &resources.AzurePowerShellScriptArgs{
 * 			Arguments:           pulumi.String("-Location 'westus' -Name \"*rg2\""),
 * 			AzPowerShellVersion: pulumi.String("1.7.0"),
 * 			CleanupPreference:   pulumi.String("Always"),
 * 			Kind:                pulumi.String("AzurePowerShell"),
 * 			Location:            pulumi.String("westus"),
 * 			ResourceGroupName:   pulumi.String("script-rg"),
 * 			RetentionInterval:   pulumi.String("PT7D"),
 * 			ScriptContent:       pulumi.String("Param([string]$Location,[string]$Name) $deploymentScriptOutputs['test'] = 'value' Get-AzResourceGroup -Location $Location -Name $Name"),
 * 			ScriptName:          pulumi.String("MyDeploymentScript"),
 * 			SupportingScriptUris: pulumi.StringArray{
 * 				pulumi.String("https://uri1.to.supporting.script"),
 * 				pulumi.String("https://uri2.to.supporting.script"),
 * 			},
 * 			Timeout: pulumi.String("PT1H"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.resources.AzurePowerShellScript;
 * import com.pulumi.azurenative.resources.AzurePowerShellScriptArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var azurePowerShellScript = new AzurePowerShellScript("azurePowerShellScript", AzurePowerShellScriptArgs.builder()
 *             .arguments("-Location 'westus' -Name \"*rg2\"")
 *             .azPowerShellVersion("1.7.0")
 *             .cleanupPreference("Always")
 *             .kind("AzurePowerShell")
 *             .location("westus")
 *             .resourceGroupName("script-rg")
 *             .retentionInterval("PT7D")
 *             .scriptContent("Param([string]$Location,[string]$Name) $deploymentScriptOutputs['test'] = 'value' Get-AzResourceGroup -Location $Location -Name $Name")
 *             .scriptName("MyDeploymentScript")
 *             .supportingScriptUris(
 *                 "https://uri1.to.supporting.script",
 *                 "https://uri2.to.supporting.script")
 *             .timeout("PT1H")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:resources:AzurePowerShellScript myresource1 /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deploymentScripts/{scriptName}
 * ```
 * @property arguments Command line arguments to pass to the script. Arguments are separated by spaces. ex: -Name blue* -Location 'West US 2'
 * @property azPowerShellVersion Azure PowerShell module version to be used.
 * @property cleanupPreference The clean up preference when the script execution gets in a terminal state. Default setting is 'Always'.
 * @property containerSettings Container settings.
 * @property environmentVariables The environment variables to pass over to the script.
 * @property forceUpdateTag Gets or sets how the deployment script should be forced to execute even if the script resource has not changed. Can be current time stamp or a GUID.
 * @property identity Optional property. Managed identity to be used for this deployment script. Currently, only user-assigned MSI is supported.
 * @property kind Type of the script.
 * Expected value is 'AzurePowerShell'.
 * @property location The location of the ACI and the storage account for the deployment script.
 * @property primaryScriptUri Uri for the script. This is the entry point for the external script.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property retentionInterval Interval for which the service retains the script resource after it reaches a terminal state. Resource will be deleted when this duration expires. Duration is based on ISO 8601 pattern (for example P1D means one day).
 * @property scriptContent Script body.
 * @property scriptName Name of the deployment script.
 * @property storageAccountSettings Storage Account settings.
 * @property supportingScriptUris Supporting files for the external script.
 * @property tags Resource tags.
 * @property timeout Maximum allowed script execution time specified in ISO 8601 format. Default value is P1D
 */
public data class AzurePowerShellScriptArgs(
    public val arguments: Output<String>? = null,
    public val azPowerShellVersion: Output<String>? = null,
    public val cleanupPreference: Output<Either<String, CleanupOptions>>? = null,
    public val containerSettings: Output<ContainerConfigurationArgs>? = null,
    public val environmentVariables: Output<List<EnvironmentVariableArgs>>? = null,
    public val forceUpdateTag: Output<String>? = null,
    public val identity: Output<ManagedServiceIdentityArgs>? = null,
    public val kind: Output<String>? = null,
    public val location: Output<String>? = null,
    public val primaryScriptUri: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val retentionInterval: Output<String>? = null,
    public val scriptContent: Output<String>? = null,
    public val scriptName: Output<String>? = null,
    public val storageAccountSettings: Output<StorageAccountConfigurationArgs>? = null,
    public val supportingScriptUris: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timeout: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.resources.AzurePowerShellScriptArgs> {
    override fun toJava(): com.pulumi.azurenative.resources.AzurePowerShellScriptArgs =
        com.pulumi.azurenative.resources.AzurePowerShellScriptArgs.builder()
            .arguments(arguments?.applyValue({ args0 -> args0 }))
            .azPowerShellVersion(azPowerShellVersion?.applyValue({ args0 -> args0 }))
            .cleanupPreference(
                cleanupPreference?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .containerSettings(containerSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .environmentVariables(
                environmentVariables?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .forceUpdateTag(forceUpdateTag?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .primaryScriptUri(primaryScriptUri?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .retentionInterval(retentionInterval?.applyValue({ args0 -> args0 }))
            .scriptContent(scriptContent?.applyValue({ args0 -> args0 }))
            .scriptName(scriptName?.applyValue({ args0 -> args0 }))
            .storageAccountSettings(
                storageAccountSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .supportingScriptUris(supportingScriptUris?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timeout(timeout?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzurePowerShellScriptArgs].
 */
@PulumiTagMarker
public class AzurePowerShellScriptArgsBuilder internal constructor() {
    private var arguments: Output<String>? = null

    private var azPowerShellVersion: Output<String>? = null

    private var cleanupPreference: Output<Either<String, CleanupOptions>>? = null

    private var containerSettings: Output<ContainerConfigurationArgs>? = null

    private var environmentVariables: Output<List<EnvironmentVariableArgs>>? = null

    private var forceUpdateTag: Output<String>? = null

    private var identity: Output<ManagedServiceIdentityArgs>? = null

    private var kind: Output<String>? = null

    private var location: Output<String>? = null

    private var primaryScriptUri: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var retentionInterval: Output<String>? = null

    private var scriptContent: Output<String>? = null

    private var scriptName: Output<String>? = null

    private var storageAccountSettings: Output<StorageAccountConfigurationArgs>? = null

    private var supportingScriptUris: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timeout: Output<String>? = null

    /**
     * @param value Command line arguments to pass to the script. Arguments are separated by spaces. ex: -Name blue* -Location 'West US 2'
     */
    @JvmName("ajpkpieswomtemvb")
    public suspend fun arguments(`value`: Output<String>) {
        this.arguments = value
    }

    /**
     * @param value Azure PowerShell module version to be used.
     */
    @JvmName("ujiqoxejqtxxegut")
    public suspend fun azPowerShellVersion(`value`: Output<String>) {
        this.azPowerShellVersion = value
    }

    /**
     * @param value The clean up preference when the script execution gets in a terminal state. Default setting is 'Always'.
     */
    @JvmName("yebjuhksjiujpsuq")
    public suspend fun cleanupPreference(`value`: Output<Either<String, CleanupOptions>>) {
        this.cleanupPreference = value
    }

    /**
     * @param value Container settings.
     */
    @JvmName("nuvmhyngqbwlxuts")
    public suspend fun containerSettings(`value`: Output<ContainerConfigurationArgs>) {
        this.containerSettings = value
    }

    /**
     * @param value The environment variables to pass over to the script.
     */
    @JvmName("vshwhfptctrcrrla")
    public suspend fun environmentVariables(`value`: Output<List<EnvironmentVariableArgs>>) {
        this.environmentVariables = value
    }

    @JvmName("oluylsqcfkbhyemh")
    public suspend fun environmentVariables(vararg values: Output<EnvironmentVariableArgs>) {
        this.environmentVariables = Output.all(values.asList())
    }

    /**
     * @param values The environment variables to pass over to the script.
     */
    @JvmName("iupanhmkicjcsjlo")
    public suspend fun environmentVariables(values: List<Output<EnvironmentVariableArgs>>) {
        this.environmentVariables = Output.all(values)
    }

    /**
     * @param value Gets or sets how the deployment script should be forced to execute even if the script resource has not changed. Can be current time stamp or a GUID.
     */
    @JvmName("ufvfnelarxrngrvp")
    public suspend fun forceUpdateTag(`value`: Output<String>) {
        this.forceUpdateTag = value
    }

    /**
     * @param value Optional property. Managed identity to be used for this deployment script. Currently, only user-assigned MSI is supported.
     */
    @JvmName("kfmrmqilcwefcips")
    public suspend fun identity(`value`: Output<ManagedServiceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value Type of the script.
     * Expected value is 'AzurePowerShell'.
     */
    @JvmName("aibejappfsuonhqs")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The location of the ACI and the storage account for the deployment script.
     */
    @JvmName("aauphdfbjgimgsnh")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Uri for the script. This is the entry point for the external script.
     */
    @JvmName("qsipflkcksrcsvhq")
    public suspend fun primaryScriptUri(`value`: Output<String>) {
        this.primaryScriptUri = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xmrincbnkcpdyqec")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Interval for which the service retains the script resource after it reaches a terminal state. Resource will be deleted when this duration expires. Duration is based on ISO 8601 pattern (for example P1D means one day).
     */
    @JvmName("orfeeshiwsouragk")
    public suspend fun retentionInterval(`value`: Output<String>) {
        this.retentionInterval = value
    }

    /**
     * @param value Script body.
     */
    @JvmName("bgngoeqkwiaoxqle")
    public suspend fun scriptContent(`value`: Output<String>) {
        this.scriptContent = value
    }

    /**
     * @param value Name of the deployment script.
     */
    @JvmName("cqqmhhsfelobxuob")
    public suspend fun scriptName(`value`: Output<String>) {
        this.scriptName = value
    }

    /**
     * @param value Storage Account settings.
     */
    @JvmName("vufrqxplubdjwjuc")
    public suspend fun storageAccountSettings(`value`: Output<StorageAccountConfigurationArgs>) {
        this.storageAccountSettings = value
    }

    /**
     * @param value Supporting files for the external script.
     */
    @JvmName("jdrdvoiaalwsrjwh")
    public suspend fun supportingScriptUris(`value`: Output<List<String>>) {
        this.supportingScriptUris = value
    }

    @JvmName("fbsjbrbdgisfrlpt")
    public suspend fun supportingScriptUris(vararg values: Output<String>) {
        this.supportingScriptUris = Output.all(values.asList())
    }

    /**
     * @param values Supporting files for the external script.
     */
    @JvmName("iugogdyrnxhyugdg")
    public suspend fun supportingScriptUris(values: List<Output<String>>) {
        this.supportingScriptUris = Output.all(values)
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("kethtdnuueqdyrrc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Maximum allowed script execution time specified in ISO 8601 format. Default value is P1D
     */
    @JvmName("vwcmqrlwymptdrsv")
    public suspend fun timeout(`value`: Output<String>) {
        this.timeout = value
    }

    /**
     * @param value Command line arguments to pass to the script. Arguments are separated by spaces. ex: -Name blue* -Location 'West US 2'
     */
    @JvmName("ulctgwcjcqjriteg")
    public suspend fun arguments(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arguments = mapped
    }

    /**
     * @param value Azure PowerShell module version to be used.
     */
    @JvmName("vbqnktmgwgqqcyjg")
    public suspend fun azPowerShellVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azPowerShellVersion = mapped
    }

    /**
     * @param value The clean up preference when the script execution gets in a terminal state. Default setting is 'Always'.
     */
    @JvmName("jecolbcedvbrvojb")
    public suspend fun cleanupPreference(`value`: Either<String, CleanupOptions>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cleanupPreference = mapped
    }

    /**
     * @param value The clean up preference when the script execution gets in a terminal state. Default setting is 'Always'.
     */
    @JvmName("onpyqojmnkoktnsw")
    public fun cleanupPreference(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CleanupOptions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cleanupPreference = mapped
    }

    /**
     * @param value The clean up preference when the script execution gets in a terminal state. Default setting is 'Always'.
     */
    @JvmName("yvqpfslhvxeutjyg")
    public fun cleanupPreference(`value`: CleanupOptions) {
        val toBeMapped = Either.ofRight<String, CleanupOptions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cleanupPreference = mapped
    }

    /**
     * @param value Container settings.
     */
    @JvmName("sbfgbnxwirrseofx")
    public suspend fun containerSettings(`value`: ContainerConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerSettings = mapped
    }

    /**
     * @param argument Container settings.
     */
    @JvmName("oteomsrsywxorbaf")
    public suspend
    fun containerSettings(argument: suspend ContainerConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.containerSettings = mapped
    }

    /**
     * @param value The environment variables to pass over to the script.
     */
    @JvmName("rdohmqtpvvvuhvot")
    public suspend fun environmentVariables(`value`: List<EnvironmentVariableArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param argument The environment variables to pass over to the script.
     */
    @JvmName("sarnhqvbsvgubxfc")
    public suspend
    fun environmentVariables(argument: List<suspend EnvironmentVariableArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EnvironmentVariableArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.environmentVariables = mapped
    }

    /**
     * @param argument The environment variables to pass over to the script.
     */
    @JvmName("ymkhuoaqfapbuccd")
    public suspend fun environmentVariables(
        vararg
        argument: suspend EnvironmentVariableArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            EnvironmentVariableArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.environmentVariables = mapped
    }

    /**
     * @param argument The environment variables to pass over to the script.
     */
    @JvmName("fxhlgvlhlfygwelo")
    public suspend
    fun environmentVariables(argument: suspend EnvironmentVariableArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EnvironmentVariableArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.environmentVariables = mapped
    }

    /**
     * @param values The environment variables to pass over to the script.
     */
    @JvmName("rikxoyfwhhthcmuw")
    public suspend fun environmentVariables(vararg values: EnvironmentVariableArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param value Gets or sets how the deployment script should be forced to execute even if the script resource has not changed. Can be current time stamp or a GUID.
     */
    @JvmName("gbxvrytftdivtyih")
    public suspend fun forceUpdateTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceUpdateTag = mapped
    }

    /**
     * @param value Optional property. Managed identity to be used for this deployment script. Currently, only user-assigned MSI is supported.
     */
    @JvmName("yeqjjylnsxalkcik")
    public suspend fun identity(`value`: ManagedServiceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Optional property. Managed identity to be used for this deployment script. Currently, only user-assigned MSI is supported.
     */
    @JvmName("nafwxnrqpjmyrpiv")
    public suspend fun identity(argument: suspend ManagedServiceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedServiceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Type of the script.
     * Expected value is 'AzurePowerShell'.
     */
    @JvmName("tdcwylbmgpkvudfo")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The location of the ACI and the storage account for the deployment script.
     */
    @JvmName("huxiquyajqgxwsrg")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Uri for the script. This is the entry point for the external script.
     */
    @JvmName("pyhrwugpgrkauxpx")
    public suspend fun primaryScriptUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryScriptUri = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ivfqiwsaihicscoe")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Interval for which the service retains the script resource after it reaches a terminal state. Resource will be deleted when this duration expires. Duration is based on ISO 8601 pattern (for example P1D means one day).
     */
    @JvmName("ctrkptcrpgmlskit")
    public suspend fun retentionInterval(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionInterval = mapped
    }

    /**
     * @param value Script body.
     */
    @JvmName("cjcjpvqytyowosxk")
    public suspend fun scriptContent(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scriptContent = mapped
    }

    /**
     * @param value Name of the deployment script.
     */
    @JvmName("uvbxlxudrfhixqov")
    public suspend fun scriptName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scriptName = mapped
    }

    /**
     * @param value Storage Account settings.
     */
    @JvmName("bbpvogdotxvxlchg")
    public suspend fun storageAccountSettings(`value`: StorageAccountConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountSettings = mapped
    }

    /**
     * @param argument Storage Account settings.
     */
    @JvmName("pordcxnthlgqcfrx")
    public suspend
    fun storageAccountSettings(argument: suspend StorageAccountConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = StorageAccountConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.storageAccountSettings = mapped
    }

    /**
     * @param value Supporting files for the external script.
     */
    @JvmName("ppqflivttiaqoxil")
    public suspend fun supportingScriptUris(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.supportingScriptUris = mapped
    }

    /**
     * @param values Supporting files for the external script.
     */
    @JvmName("afyibyeasbiviaij")
    public suspend fun supportingScriptUris(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.supportingScriptUris = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("debcuplwjugoyleq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("ilgpqvgkxafsjupo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Maximum allowed script execution time specified in ISO 8601 format. Default value is P1D
     */
    @JvmName("yqaixgmlplficjus")
    public suspend fun timeout(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    internal fun build(): AzurePowerShellScriptArgs = AzurePowerShellScriptArgs(
        arguments = arguments,
        azPowerShellVersion = azPowerShellVersion,
        cleanupPreference = cleanupPreference,
        containerSettings = containerSettings,
        environmentVariables = environmentVariables,
        forceUpdateTag = forceUpdateTag,
        identity = identity,
        kind = kind,
        location = location,
        primaryScriptUri = primaryScriptUri,
        resourceGroupName = resourceGroupName,
        retentionInterval = retentionInterval,
        scriptContent = scriptContent,
        scriptName = scriptName,
        storageAccountSettings = storageAccountSettings,
        supportingScriptUris = supportingScriptUris,
        tags = tags,
        timeout = timeout,
    )
}
