@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin

import com.pulumi.azurenative.resources.kotlin.outputs.DeploymentPropertiesExtendedResponse
import com.pulumi.azurenative.resources.kotlin.outputs.DeploymentPropertiesExtendedResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [DeploymentAtManagementGroupScope].
 */
@PulumiTagMarker
public class DeploymentAtManagementGroupScopeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DeploymentAtManagementGroupScopeArgs = DeploymentAtManagementGroupScopeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DeploymentAtManagementGroupScopeArgsBuilder.() -> Unit) {
        val builder = DeploymentAtManagementGroupScopeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DeploymentAtManagementGroupScope {
        val builtJavaResource =
            com.pulumi.azurenative.resources.DeploymentAtManagementGroupScope(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DeploymentAtManagementGroupScope(builtJavaResource)
    }
}

/**
 * Deployment information.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2021-01-01.
 * Other available API versions: 2023-07-01.
 * ## Example Usage
 * ### Create deployment at management group scope.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var deploymentAtManagementGroupScope = new AzureNative.Resources.DeploymentAtManagementGroupScope("deploymentAtManagementGroupScope", new()
 *     {
 *         DeploymentName = "my-deployment",
 *         GroupId = "my-management-group-id",
 *         Location = "eastus",
 *         Properties = new AzureNative.Resources.Inputs.DeploymentPropertiesArgs
 *         {
 *             Mode = AzureNative.Resources.DeploymentMode.Incremental,
 *             Parameters = null,
 *             TemplateLink = new AzureNative.Resources.Inputs.TemplateLinkArgs
 *             {
 *                 Uri = "https://example.com/exampleTemplate.json",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/resources/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := resources.NewDeploymentAtManagementGroupScope(ctx, "deploymentAtManagementGroupScope", &resources.DeploymentAtManagementGroupScopeArgs{
 * 			DeploymentName: pulumi.String("my-deployment"),
 * 			GroupId:        pulumi.String("my-management-group-id"),
 * 			Location:       pulumi.String("eastus"),
 * 			Properties: resources.DeploymentPropertiesExtendedResponse{
 * 				Mode:       resources.DeploymentModeIncremental,
 * 				Parameters: nil,
 * 				TemplateLink: &resources.TemplateLinkArgs{
 * 					Uri: pulumi.String("https://example.com/exampleTemplate.json"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.resources.DeploymentAtManagementGroupScope;
 * import com.pulumi.azurenative.resources.DeploymentAtManagementGroupScopeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var deploymentAtManagementGroupScope = new DeploymentAtManagementGroupScope("deploymentAtManagementGroupScope", DeploymentAtManagementGroupScopeArgs.builder()
 *             .deploymentName("my-deployment")
 *             .groupId("my-management-group-id")
 *             .location("eastus")
 *             .properties(Map.ofEntries(
 *                 Map.entry("mode", "Incremental"),
 *                 Map.entry("parameters", ),
 *                 Map.entry("templateLink", Map.of("uri", "https://example.com/exampleTemplate.json"))
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:resources:DeploymentAtManagementGroupScope my-deployment /providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}
 * ```
 */
public class DeploymentAtManagementGroupScope internal constructor(
    override val javaResource: com.pulumi.azurenative.resources.DeploymentAtManagementGroupScope,
) : KotlinCustomResource(javaResource, DeploymentAtManagementGroupScopeMapper) {
    /**
     * the location of the deployment.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the deployment.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Deployment properties.
     */
    public val properties: Output<DeploymentPropertiesExtendedResponse>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Deployment tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the deployment.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DeploymentAtManagementGroupScopeMapper :
    ResourceMapper<DeploymentAtManagementGroupScope> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.resources.DeploymentAtManagementGroupScope::class == javaResource::class

    override fun map(javaResource: Resource): DeploymentAtManagementGroupScope =
        DeploymentAtManagementGroupScope(
            javaResource as
                com.pulumi.azurenative.resources.DeploymentAtManagementGroupScope,
        )
}

/**
 * @see [DeploymentAtManagementGroupScope].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DeploymentAtManagementGroupScope].
 */
public suspend fun deploymentAtManagementGroupScope(
    name: String,
    block: suspend DeploymentAtManagementGroupScopeResourceBuilder.() -> Unit,
):
    DeploymentAtManagementGroupScope {
    val builder = DeploymentAtManagementGroupScopeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DeploymentAtManagementGroupScope].
 * @param name The _unique_ name of the resulting resource.
 */
public fun deploymentAtManagementGroupScope(name: String): DeploymentAtManagementGroupScope {
    val builder = DeploymentAtManagementGroupScopeResourceBuilder()
    builder.name(name)
    return builder.build()
}
