@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin

import com.pulumi.azurenative.resources.DeploymentAtManagementGroupScopeArgs.builder
import com.pulumi.azurenative.resources.kotlin.inputs.DeploymentPropertiesArgs
import com.pulumi.azurenative.resources.kotlin.inputs.DeploymentPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Deployment information.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2021-01-01.
 * Other available API versions: 2023-07-01.
 * ## Example Usage
 * ### Create deployment at management group scope.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var deploymentAtManagementGroupScope = new AzureNative.Resources.DeploymentAtManagementGroupScope("deploymentAtManagementGroupScope", new()
 *     {
 *         DeploymentName = "my-deployment",
 *         GroupId = "my-management-group-id",
 *         Location = "eastus",
 *         Properties = new AzureNative.Resources.Inputs.DeploymentPropertiesArgs
 *         {
 *             Mode = AzureNative.Resources.DeploymentMode.Incremental,
 *             Parameters = null,
 *             TemplateLink = new AzureNative.Resources.Inputs.TemplateLinkArgs
 *             {
 *                 Uri = "https://example.com/exampleTemplate.json",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/resources/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := resources.NewDeploymentAtManagementGroupScope(ctx, "deploymentAtManagementGroupScope", &resources.DeploymentAtManagementGroupScopeArgs{
 * 			DeploymentName: pulumi.String("my-deployment"),
 * 			GroupId:        pulumi.String("my-management-group-id"),
 * 			Location:       pulumi.String("eastus"),
 * 			Properties: resources.DeploymentPropertiesExtendedResponse{
 * 				Mode:       resources.DeploymentModeIncremental,
 * 				Parameters: nil,
 * 				TemplateLink: &resources.TemplateLinkArgs{
 * 					Uri: pulumi.String("https://example.com/exampleTemplate.json"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.resources.DeploymentAtManagementGroupScope;
 * import com.pulumi.azurenative.resources.DeploymentAtManagementGroupScopeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var deploymentAtManagementGroupScope = new DeploymentAtManagementGroupScope("deploymentAtManagementGroupScope", DeploymentAtManagementGroupScopeArgs.builder()
 *             .deploymentName("my-deployment")
 *             .groupId("my-management-group-id")
 *             .location("eastus")
 *             .properties(Map.ofEntries(
 *                 Map.entry("mode", "Incremental"),
 *                 Map.entry("parameters", ),
 *                 Map.entry("templateLink", Map.of("uri", "https://example.com/exampleTemplate.json"))
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:resources:DeploymentAtManagementGroupScope my-deployment /providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}
 * ```
 * @property deploymentName The name of the deployment.
 * @property groupId The management group ID.
 * @property location The location to store the deployment data.
 * @property properties The deployment properties.
 * @property tags Deployment tags
 */
public data class DeploymentAtManagementGroupScopeArgs(
    public val deploymentName: Output<String>? = null,
    public val groupId: Output<String>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<DeploymentPropertiesArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.resources.DeploymentAtManagementGroupScopeArgs> {
    override fun toJava(): com.pulumi.azurenative.resources.DeploymentAtManagementGroupScopeArgs =
        com.pulumi.azurenative.resources.DeploymentAtManagementGroupScopeArgs.builder()
            .deploymentName(deploymentName?.applyValue({ args0 -> args0 }))
            .groupId(groupId?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DeploymentAtManagementGroupScopeArgs].
 */
@PulumiTagMarker
public class DeploymentAtManagementGroupScopeArgsBuilder internal constructor() {
    private var deploymentName: Output<String>? = null

    private var groupId: Output<String>? = null

    private var location: Output<String>? = null

    private var properties: Output<DeploymentPropertiesArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the deployment.
     */
    @JvmName("sfjdkvgviwgyshdj")
    public suspend fun deploymentName(`value`: Output<String>) {
        this.deploymentName = value
    }

    /**
     * @param value The management group ID.
     */
    @JvmName("lbvsfknvfnpsqjuc")
    public suspend fun groupId(`value`: Output<String>) {
        this.groupId = value
    }

    /**
     * @param value The location to store the deployment data.
     */
    @JvmName("wnqjribbdhhqrqgr")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The deployment properties.
     */
    @JvmName("oslbqmqnnxfsgcor")
    public suspend fun properties(`value`: Output<DeploymentPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Deployment tags
     */
    @JvmName("armdbuccptqoywao")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the deployment.
     */
    @JvmName("etgnmnfgcrotapyd")
    public suspend fun deploymentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentName = mapped
    }

    /**
     * @param value The management group ID.
     */
    @JvmName("krggavctumonpvur")
    public suspend fun groupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    /**
     * @param value The location to store the deployment data.
     */
    @JvmName("trllbqypfpednrxo")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The deployment properties.
     */
    @JvmName("cwalygtcespwaier")
    public suspend fun properties(`value`: DeploymentPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The deployment properties.
     */
    @JvmName("vvybidqhpaacskqm")
    public suspend fun properties(argument: suspend DeploymentPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = DeploymentPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value Deployment tags
     */
    @JvmName("vvqdearakamaatbo")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Deployment tags
     */
    @JvmName("mafrgiirugkdadde")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DeploymentAtManagementGroupScopeArgs = DeploymentAtManagementGroupScopeArgs(
        deploymentName = deploymentName,
        groupId = groupId,
        location = location,
        properties = properties,
        tags = tags,
    )
}
