@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin

import com.pulumi.azurenative.resources.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.resources.kotlin.outputs.TemplateSpecVersionInfoResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.resources.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.resources.kotlin.outputs.TemplateSpecVersionInfoResponse.Companion.toKotlin as templateSpecVersionInfoResponseToKotlin

/**
 * Builder for [TemplateSpec].
 */
@PulumiTagMarker
public class TemplateSpecResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TemplateSpecArgs = TemplateSpecArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TemplateSpecArgsBuilder.() -> Unit) {
        val builder = TemplateSpecArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): TemplateSpec {
        val builtJavaResource = com.pulumi.azurenative.resources.TemplateSpec(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return TemplateSpec(builtJavaResource)
    }
}

/**
 * Template Spec object.
 * Azure REST API version: 2022-02-01. Prior API version in Azure Native 1.x: 2022-02-01.
 * ## Example Usage
 * ### TemplateSpecsCreateUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var templateSpec = new AzureNative.Resources.TemplateSpec("templateSpec", new()
 *     {
 *         Description = "A very simple Template Spec",
 *         Location = "eastus",
 *         ResourceGroupName = "templateSpecRG",
 *         TemplateSpecName = "simpleTemplateSpec",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/resources/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := resources.NewTemplateSpec(ctx, "templateSpec", &resources.TemplateSpecArgs{
 * 			Description:       pulumi.String("A very simple Template Spec"),
 * 			Location:          pulumi.String("eastus"),
 * 			ResourceGroupName: pulumi.String("templateSpecRG"),
 * 			TemplateSpecName:  pulumi.String("simpleTemplateSpec"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.resources.TemplateSpec;
 * import com.pulumi.azurenative.resources.TemplateSpecArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var templateSpec = new TemplateSpec("templateSpec", TemplateSpecArgs.builder()
 *             .description("A very simple Template Spec")
 *             .location("eastus")
 *             .resourceGroupName("templateSpecRG")
 *             .templateSpecName("simpleTemplateSpec")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:resources:TemplateSpec simpleTemplateSpec /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Resources/templateSpecs/{templateSpecName}
 * ```
 */
public class TemplateSpec internal constructor(
    override val javaResource: com.pulumi.azurenative.resources.TemplateSpec,
) : KotlinCustomResource(javaResource, TemplateSpecMapper) {
    /**
     * Template Spec description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Template Spec display name.
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The location of the Template Spec. It cannot be changed after Template Spec creation. It must be one of the supported Azure locations.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The Template Spec metadata. Metadata is an open-ended object and is typically a collection of key-value pairs.
     */
    public val metadata: Output<Any>?
        get() = javaResource.metadata().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Name of this resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Type of this resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * High-level information about the versions within this Template Spec. The keys are the version names. Only populated if the $expand query parameter is set to 'versions'.
     */
    public val versions: Output<Map<String, TemplateSpecVersionInfoResponse>>
        get() = javaResource.versions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        templateSpecVersionInfoResponseToKotlin(args0)
                    }),
                )
            }).toMap()
        })
}

public object TemplateSpecMapper : ResourceMapper<TemplateSpec> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.resources.TemplateSpec::class == javaResource::class

    override fun map(javaResource: Resource): TemplateSpec = TemplateSpec(
        javaResource as
            com.pulumi.azurenative.resources.TemplateSpec,
    )
}

/**
 * @see [TemplateSpec].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TemplateSpec].
 */
public suspend fun templateSpec(
    name: String,
    block: suspend TemplateSpecResourceBuilder.() -> Unit,
): TemplateSpec {
    val builder = TemplateSpecResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TemplateSpec].
 * @param name The _unique_ name of the resulting resource.
 */
public fun templateSpec(name: String): TemplateSpec {
    val builder = TemplateSpecResourceBuilder()
    builder.name(name)
    return builder.build()
}
