@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The deployment on error behavior type. Possible values are LastSuccessful and SpecificDeployment.
 */
public enum class OnErrorDeploymentType(
    public val javaValue: com.pulumi.azurenative.resources.enums.OnErrorDeploymentType,
) : ConvertibleToJava<com.pulumi.azurenative.resources.enums.OnErrorDeploymentType> {
    LastSuccessful(com.pulumi.azurenative.resources.enums.OnErrorDeploymentType.LastSuccessful),
    SpecificDeployment(com.pulumi.azurenative.resources.enums.OnErrorDeploymentType.SpecificDeployment),
    ;

    override fun toJava(): com.pulumi.azurenative.resources.enums.OnErrorDeploymentType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.resources.enums.OnErrorDeploymentType):
            OnErrorDeploymentType = OnErrorDeploymentType.values().first { it.javaValue == javaType }
    }
}
