@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.inputs

import com.pulumi.azurenative.resources.inputs.ContainerConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Settings to customize ACI container instance.
 * @property containerGroupName Container group name, if not specified then the name will get auto-generated. Not specifying a 'containerGroupName' indicates the system to generate a unique name which might end up flagging an Azure Policy as non-compliant. Use 'containerGroupName' when you have an Azure Policy that expects a specific naming convention or when you want to fully control the name. 'containerGroupName' property must be between 1 and 63 characters long, must contain only lowercase letters, numbers, and dashes and it cannot start or end with a dash and consecutive dashes are not allowed. To specify a 'containerGroupName', add the following object to properties: { "containerSettings": { "containerGroupName": "contoso-container" } }. If you do not want to specify a 'containerGroupName' then do not add 'containerSettings' property.
 */
public data class ContainerConfigurationArgs(
    public val containerGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.resources.inputs.ContainerConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.resources.inputs.ContainerConfigurationArgs =
        com.pulumi.azurenative.resources.inputs.ContainerConfigurationArgs.builder()
            .containerGroupName(containerGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerConfigurationArgs].
 */
@PulumiTagMarker
public class ContainerConfigurationArgsBuilder internal constructor() {
    private var containerGroupName: Output<String>? = null

    /**
     * @param value Container group name, if not specified then the name will get auto-generated. Not specifying a 'containerGroupName' indicates the system to generate a unique name which might end up flagging an Azure Policy as non-compliant. Use 'containerGroupName' when you have an Azure Policy that expects a specific naming convention or when you want to fully control the name. 'containerGroupName' property must be between 1 and 63 characters long, must contain only lowercase letters, numbers, and dashes and it cannot start or end with a dash and consecutive dashes are not allowed. To specify a 'containerGroupName', add the following object to properties: { "containerSettings": { "containerGroupName": "contoso-container" } }. If you do not want to specify a 'containerGroupName' then do not add 'containerSettings' property.
     */
    @JvmName("chaqetkuucrenphx")
    public suspend fun containerGroupName(`value`: Output<String>) {
        this.containerGroupName = value
    }

    /**
     * @param value Container group name, if not specified then the name will get auto-generated. Not specifying a 'containerGroupName' indicates the system to generate a unique name which might end up flagging an Azure Policy as non-compliant. Use 'containerGroupName' when you have an Azure Policy that expects a specific naming convention or when you want to fully control the name. 'containerGroupName' property must be between 1 and 63 characters long, must contain only lowercase letters, numbers, and dashes and it cannot start or end with a dash and consecutive dashes are not allowed. To specify a 'containerGroupName', add the following object to properties: { "containerSettings": { "containerGroupName": "contoso-container" } }. If you do not want to specify a 'containerGroupName' then do not add 'containerSettings' property.
     */
    @JvmName("nvhvjweluqceegsv")
    public suspend fun containerGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerGroupName = mapped
    }

    internal fun build(): ContainerConfigurationArgs = ContainerConfigurationArgs(
        containerGroupName = containerGroupName,
    )
}
