@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.inputs

import com.pulumi.azurenative.resources.inputs.EnvironmentVariableArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The environment variable to pass to the script in the container instance.
 * @property name The name of the environment variable.
 * @property secureValue The value of the secure environment variable.
 * @property value The value of the environment variable.
 */
public data class EnvironmentVariableArgs(
    public val name: Output<String>,
    public val secureValue: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.resources.inputs.EnvironmentVariableArgs> {
    override fun toJava(): com.pulumi.azurenative.resources.inputs.EnvironmentVariableArgs =
        com.pulumi.azurenative.resources.inputs.EnvironmentVariableArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .secureValue(secureValue?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EnvironmentVariableArgs].
 */
@PulumiTagMarker
public class EnvironmentVariableArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var secureValue: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The name of the environment variable.
     */
    @JvmName("jojvrqavyxentgwa")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The value of the secure environment variable.
     */
    @JvmName("cneiiqeeghuliebv")
    public suspend fun secureValue(`value`: Output<String>) {
        this.secureValue = value
    }

    /**
     * @param value The value of the environment variable.
     */
    @JvmName("neovxuagibjuyabb")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The name of the environment variable.
     */
    @JvmName("ftjwjdoywkpdrxhs")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The value of the secure environment variable.
     */
    @JvmName("edrsofiflplqliky")
    public suspend fun secureValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secureValue = mapped
    }

    /**
     * @param value The value of the environment variable.
     */
    @JvmName("olfvklqfsojeqwlq")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): EnvironmentVariableArgs = EnvironmentVariableArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        secureValue = secureValue,
        `value` = `value`,
    )
}
