@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.inputs

import com.pulumi.azurenative.resources.inputs.GetDeploymentAtManagementGroupScopePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property deploymentName The name of the deployment.
 * @property groupId The management group ID.
 */
public data class GetDeploymentAtManagementGroupScopePlainArgs(
    public val deploymentName: String,
    public val groupId: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.resources.inputs.GetDeploymentAtManagementGroupScopePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.resources.inputs.GetDeploymentAtManagementGroupScopePlainArgs =
        com.pulumi.azurenative.resources.inputs.GetDeploymentAtManagementGroupScopePlainArgs.builder()
            .deploymentName(deploymentName.let({ args0 -> args0 }))
            .groupId(groupId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDeploymentAtManagementGroupScopePlainArgs].
 */
@PulumiTagMarker
public class GetDeploymentAtManagementGroupScopePlainArgsBuilder internal constructor() {
    private var deploymentName: String? = null

    private var groupId: String? = null

    /**
     * @param value The name of the deployment.
     */
    @JvmName("qmwtfdwxiwtklmlh")
    public suspend fun deploymentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.deploymentName = mapped
    }

    /**
     * @param value The management group ID.
     */
    @JvmName("hkgubafygqsslkfa")
    public suspend fun groupId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.groupId = mapped
    }

    internal fun build(): GetDeploymentAtManagementGroupScopePlainArgs =
        GetDeploymentAtManagementGroupScopePlainArgs(
            deploymentName = deploymentName ?: throw PulumiNullFieldException("deploymentName"),
            groupId = groupId ?: throw PulumiNullFieldException("groupId"),
        )
}
