@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.inputs

import com.pulumi.azurenative.resources.inputs.GetDeploymentAtSubscriptionScopePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property deploymentName The name of the deployment.
 */
public data class GetDeploymentAtSubscriptionScopePlainArgs(
    public val deploymentName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.resources.inputs.GetDeploymentAtSubscriptionScopePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.resources.inputs.GetDeploymentAtSubscriptionScopePlainArgs =
        com.pulumi.azurenative.resources.inputs.GetDeploymentAtSubscriptionScopePlainArgs.builder()
            .deploymentName(deploymentName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDeploymentAtSubscriptionScopePlainArgs].
 */
@PulumiTagMarker
public class GetDeploymentAtSubscriptionScopePlainArgsBuilder internal constructor() {
    private var deploymentName: String? = null

    /**
     * @param value The name of the deployment.
     */
    @JvmName("gojocsttbeirhvin")
    public suspend fun deploymentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.deploymentName = mapped
    }

    internal fun build(): GetDeploymentAtSubscriptionScopePlainArgs =
        GetDeploymentAtSubscriptionScopePlainArgs(
            deploymentName = deploymentName ?: throw PulumiNullFieldException("deploymentName"),
        )
}
