@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.inputs

import com.pulumi.azurenative.resources.inputs.GetDeploymentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property deploymentName The name of the deployment.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetDeploymentPlainArgs(
    public val deploymentName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.resources.inputs.GetDeploymentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.resources.inputs.GetDeploymentPlainArgs =
        com.pulumi.azurenative.resources.inputs.GetDeploymentPlainArgs.builder()
            .deploymentName(deploymentName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDeploymentPlainArgs].
 */
@PulumiTagMarker
public class GetDeploymentPlainArgsBuilder internal constructor() {
    private var deploymentName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the deployment.
     */
    @JvmName("ddrqtivbfnjakogb")
    public suspend fun deploymentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.deploymentName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vjmxrfoevjnfxaff")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDeploymentPlainArgs = GetDeploymentPlainArgs(
        deploymentName = deploymentName ?: throw PulumiNullFieldException("deploymentName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
