@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.inputs

import com.pulumi.azurenative.resources.inputs.GetResourceGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group to get. The name is case insensitive.
 */
public data class GetResourceGroupPlainArgs(
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.resources.inputs.GetResourceGroupPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.resources.inputs.GetResourceGroupPlainArgs =
        com.pulumi.azurenative.resources.inputs.GetResourceGroupPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetResourceGroupPlainArgs].
 */
@PulumiTagMarker
public class GetResourceGroupPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    /**
     * @param value The name of the resource group to get. The name is case insensitive.
     */
    @JvmName("sdprgewxrfmhsxpw")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetResourceGroupPlainArgs = GetResourceGroupPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
