@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.inputs

import com.pulumi.azurenative.resources.inputs.GetTemplateSpecPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand Allows for expansion of additional Template Spec details in the response. Optional.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property templateSpecName Name of the Template Spec.
 */
public data class GetTemplateSpecPlainArgs(
    public val expand: String? = null,
    public val resourceGroupName: String,
    public val templateSpecName: String,
) : ConvertibleToJava<com.pulumi.azurenative.resources.inputs.GetTemplateSpecPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.resources.inputs.GetTemplateSpecPlainArgs =
        com.pulumi.azurenative.resources.inputs.GetTemplateSpecPlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .templateSpecName(templateSpecName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTemplateSpecPlainArgs].
 */
@PulumiTagMarker
public class GetTemplateSpecPlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var resourceGroupName: String? = null

    private var templateSpecName: String? = null

    /**
     * @param value Allows for expansion of additional Template Spec details in the response. Optional.
     */
    @JvmName("gcbuivisalixxpwe")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xdluaskuejjrxmop")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the Template Spec.
     */
    @JvmName("rrclpotbjraatcil")
    public suspend fun templateSpecName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.templateSpecName = mapped
    }

    internal fun build(): GetTemplateSpecPlainArgs = GetTemplateSpecPlainArgs(
        expand = expand,
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        templateSpecName = templateSpecName ?: throw PulumiNullFieldException("templateSpecName"),
    )
}
