@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.inputs

import com.pulumi.azurenative.resources.inputs.GetTemplateSpecVersionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property templateSpecName Name of the Template Spec.
 * @property templateSpecVersion The version of the Template Spec.
 */
public data class GetTemplateSpecVersionPlainArgs(
    public val resourceGroupName: String,
    public val templateSpecName: String,
    public val templateSpecVersion: String,
) : ConvertibleToJava<com.pulumi.azurenative.resources.inputs.GetTemplateSpecVersionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.resources.inputs.GetTemplateSpecVersionPlainArgs =
        com.pulumi.azurenative.resources.inputs.GetTemplateSpecVersionPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .templateSpecName(templateSpecName.let({ args0 -> args0 }))
            .templateSpecVersion(templateSpecVersion.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTemplateSpecVersionPlainArgs].
 */
@PulumiTagMarker
public class GetTemplateSpecVersionPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var templateSpecName: String? = null

    private var templateSpecVersion: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jscjdhwyutdamynl")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the Template Spec.
     */
    @JvmName("crprxbvdyvhhisiu")
    public suspend fun templateSpecName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.templateSpecName = mapped
    }

    /**
     * @param value The version of the Template Spec.
     */
    @JvmName("sspsbvttagdthiur")
    public suspend fun templateSpecVersion(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.templateSpecVersion = mapped
    }

    internal fun build(): GetTemplateSpecVersionPlainArgs = GetTemplateSpecVersionPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        templateSpecName = templateSpecName ?: throw PulumiNullFieldException("templateSpecName"),
        templateSpecVersion = templateSpecVersion ?: throw PulumiNullFieldException("templateSpecVersion"),
    )
}
