@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.inputs

import com.pulumi.azurenative.resources.inputs.KeyVaultParameterReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Azure Key Vault parameter reference.
 * @property keyVault Azure Key Vault reference.
 * @property secretName Azure Key Vault secret name.
 * @property secretVersion Azure Key Vault secret version.
 */
public data class KeyVaultParameterReferenceArgs(
    public val keyVault: Output<KeyVaultReferenceArgs>,
    public val secretName: Output<String>,
    public val secretVersion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.resources.inputs.KeyVaultParameterReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.resources.inputs.KeyVaultParameterReferenceArgs =
        com.pulumi.azurenative.resources.inputs.KeyVaultParameterReferenceArgs.builder()
            .keyVault(keyVault.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .secretName(secretName.applyValue({ args0 -> args0 }))
            .secretVersion(secretVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyVaultParameterReferenceArgs].
 */
@PulumiTagMarker
public class KeyVaultParameterReferenceArgsBuilder internal constructor() {
    private var keyVault: Output<KeyVaultReferenceArgs>? = null

    private var secretName: Output<String>? = null

    private var secretVersion: Output<String>? = null

    /**
     * @param value Azure Key Vault reference.
     */
    @JvmName("nbmdnlheatmuuukf")
    public suspend fun keyVault(`value`: Output<KeyVaultReferenceArgs>) {
        this.keyVault = value
    }

    /**
     * @param value Azure Key Vault secret name.
     */
    @JvmName("fvnutgmhilaspbmy")
    public suspend fun secretName(`value`: Output<String>) {
        this.secretName = value
    }

    /**
     * @param value Azure Key Vault secret version.
     */
    @JvmName("xnbbkpvncxtgvjwx")
    public suspend fun secretVersion(`value`: Output<String>) {
        this.secretVersion = value
    }

    /**
     * @param value Azure Key Vault reference.
     */
    @JvmName("fsixrqdqccdtsxyq")
    public suspend fun keyVault(`value`: KeyVaultReferenceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyVault = mapped
    }

    /**
     * @param argument Azure Key Vault reference.
     */
    @JvmName("xbmhpwnfsdxorjpn")
    public suspend fun keyVault(argument: suspend KeyVaultReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = KeyVaultReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.keyVault = mapped
    }

    /**
     * @param value Azure Key Vault secret name.
     */
    @JvmName("mndyorinkxaughks")
    public suspend fun secretName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secretName = mapped
    }

    /**
     * @param value Azure Key Vault secret version.
     */
    @JvmName("qxvstpksqkgpxnkn")
    public suspend fun secretVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretVersion = mapped
    }

    internal fun build(): KeyVaultParameterReferenceArgs = KeyVaultParameterReferenceArgs(
        keyVault = keyVault ?: throw PulumiNullFieldException("keyVault"),
        secretName = secretName ?: throw PulumiNullFieldException("secretName"),
        secretVersion = secretVersion,
    )
}
