@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.inputs

import com.pulumi.azurenative.resources.inputs.PlanArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Plan for the resource.
 * @property name The plan ID.
 * @property product The offer ID.
 * @property promotionCode The promotion code.
 * @property publisher The publisher ID.
 * @property version The plan's version.
 */
public data class PlanArgs(
    public val name: Output<String>? = null,
    public val product: Output<String>? = null,
    public val promotionCode: Output<String>? = null,
    public val publisher: Output<String>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.resources.inputs.PlanArgs> {
    override fun toJava(): com.pulumi.azurenative.resources.inputs.PlanArgs =
        com.pulumi.azurenative.resources.inputs.PlanArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .product(product?.applyValue({ args0 -> args0 }))
            .promotionCode(promotionCode?.applyValue({ args0 -> args0 }))
            .publisher(publisher?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PlanArgs].
 */
@PulumiTagMarker
public class PlanArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var product: Output<String>? = null

    private var promotionCode: Output<String>? = null

    private var publisher: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value The plan ID.
     */
    @JvmName("rvlmhtilbbeliejr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The offer ID.
     */
    @JvmName("wgwpfqeffbrnpqrw")
    public suspend fun product(`value`: Output<String>) {
        this.product = value
    }

    /**
     * @param value The promotion code.
     */
    @JvmName("kwpredogkwilafda")
    public suspend fun promotionCode(`value`: Output<String>) {
        this.promotionCode = value
    }

    /**
     * @param value The publisher ID.
     */
    @JvmName("ekafnteoqsoaixtb")
    public suspend fun publisher(`value`: Output<String>) {
        this.publisher = value
    }

    /**
     * @param value The plan's version.
     */
    @JvmName("akhnwadewbgwhwne")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value The plan ID.
     */
    @JvmName("gxhfglvvrsdpycxd")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The offer ID.
     */
    @JvmName("tewwsbgmcixwdour")
    public suspend fun product(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.product = mapped
    }

    /**
     * @param value The promotion code.
     */
    @JvmName("trpeyporodkqmpnx")
    public suspend fun promotionCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.promotionCode = mapped
    }

    /**
     * @param value The publisher ID.
     */
    @JvmName("fpaleoslcvddrajk")
    public suspend fun publisher(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publisher = mapped
    }

    /**
     * @param value The plan's version.
     */
    @JvmName("oaowvfywhxqlxmrr")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): PlanArgs = PlanArgs(
        name = name,
        product = product,
        promotionCode = promotionCode,
        publisher = publisher,
        version = version,
    )
}
