@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The type of the pattern for an alias path.
 * @property phrase The alias pattern phrase.
 * @property type The type of alias pattern
 * @property variable The alias pattern variable.
 */
public data class AliasPatternResponse(
    public val phrase: String? = null,
    public val type: String? = null,
    public val variable: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.resources.outputs.AliasPatternResponse):
            AliasPatternResponse = AliasPatternResponse(
            phrase = javaType.phrase().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            variable = javaType.variable().map({ args0 -> args0 }).orElse(null),
        )
    }
}
