@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property apiVersion The API version.
 * @property profileVersion The profile version.
 */
public data class ApiProfileResponse(
    public val apiVersion: String,
    public val profileVersion: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.resources.outputs.ApiProfileResponse):
            ApiProfileResponse = ApiProfileResponse(
            apiVersion = javaType.apiVersion(),
            profileVersion = javaType.profileVersion(),
        )
    }
}
