@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Deployment information.
 * @property id The ID of the deployment.
 * @property location the location of the deployment.
 * @property name The name of the deployment.
 * @property properties Deployment properties.
 * @property tags Deployment tags
 * @property type The type of the deployment.
 */
public data class GetDeploymentAtScopeResult(
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val properties: DeploymentPropertiesExtendedResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.resources.outputs.GetDeploymentAtScopeResult):
            GetDeploymentAtScopeResult = GetDeploymentAtScopeResult(
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.resources.kotlin.outputs.DeploymentPropertiesExtendedResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
