@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Resource information.
 * @property extendedLocation Resource extended location.
 * @property id Resource ID
 * @property identity The identity of the resource.
 * @property kind The kind of the resource.
 * @property location Resource location
 * @property managedBy ID of the resource that manages this resource.
 * @property name Resource name
 * @property plan The plan of the resource.
 * @property properties The resource properties.
 * @property sku The SKU of the resource.
 * @property tags Resource tags
 * @property type Resource type
 */
public data class GetResourceResult(
    public val extendedLocation: ExtendedLocationResponse? = null,
    public val id: String,
    public val identity: IdentityResponse? = null,
    public val kind: String? = null,
    public val location: String? = null,
    public val managedBy: String? = null,
    public val name: String,
    public val plan: PlanResponse? = null,
    public val properties: Any,
    public val sku: SkuResponse? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.resources.outputs.GetResourceResult):
            GetResourceResult = GetResourceResult(
            extendedLocation = javaType.extendedLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.resources.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.resources.kotlin.outputs.IdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            managedBy = javaType.managedBy().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            plan = javaType.plan().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.resources.kotlin.outputs.PlanResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            properties = javaType.properties(),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.resources.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
