@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Represents a Template Spec artifact containing an embedded Azure Resource Manager template for use as a linked template.
 * @property path A filesystem safe relative path of the artifact.
 * @property template The Azure Resource Manager template.
 */
public data class LinkedTemplateArtifactResponse(
    public val path: String,
    public val template: Any,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.resources.outputs.LinkedTemplateArtifactResponse):
            LinkedTemplateArtifactResponse = LinkedTemplateArtifactResponse(
            path = javaType.path(),
            template = javaType.template(),
        )
    }
}
