@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Managed identity generic object.
 * @property tenantId ID of the Azure Active Directory.
 * @property type Type of the managed identity.
 * @property userAssignedIdentities The list of user-assigned managed identities associated with the resource. Key is the Azure resource Id of the managed identity.
 */
public data class ManagedServiceIdentityResponse(
    public val tenantId: String,
    public val type: String? = null,
    public val userAssignedIdentities: Map<String, UserAssignedIdentityResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.resources.outputs.ManagedServiceIdentityResponse):
            ManagedServiceIdentityResponse = ManagedServiceIdentityResponse(
            tenantId = javaType.tenantId(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            userAssignedIdentities = javaType.userAssignedIdentities().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.resources.kotlin.outputs.UserAssignedIdentityResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
        )
    }
}
