@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Generic object modeling results of script execution.
 * @property containerInstanceId ACI resource Id.
 * @property endTime End time of the script execution.
 * @property error Error that is relayed from the script execution.
 * @property expirationTime Time the deployment script resource will expire.
 * @property startTime Start time of the script execution.
 * @property storageAccountId Storage account resource Id.
 */
public data class ScriptStatusResponse(
    public val containerInstanceId: String,
    public val endTime: String,
    public val error: ErrorResponseResponse? = null,
    public val expirationTime: String,
    public val startTime: String,
    public val storageAccountId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.resources.outputs.ScriptStatusResponse):
            ScriptStatusResponse = ScriptStatusResponse(
            containerInstanceId = javaType.containerInstanceId(),
            endTime = javaType.endTime(),
            error = javaType.error().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.resources.kotlin.outputs.ErrorResponseResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            expirationTime = javaType.expirationTime(),
            startTime = javaType.startTime(),
            storageAccountId = javaType.storageAccountId(),
        )
    }
}
